/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.framework.project.api.toolchain.core.ToolchainUtils;
import com.silabs.ss.framework.uc.core.internal.persist.CorePersistables;
import com.silabs.ss.framework.uc.core.internal.persist.IPersistedCliConfig;
import com.silabs.ss.framework.uc.core.internal.persist.PersistEntry;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.UcCliConfigWarning;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="configuration", description={"Examine and modify configuration options. Configuration of the command line allow you to omit common parameters by providing sensical defaults for your setup"}, subcommands={UcCliConfigWarning.class})
public class UcCliConfiguration
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Option(names={"-s", "--sdk"}, paramLabel="SDK_PATH", description={"Location of sdk definition file. Supplying an empty string (--sdk=\"\") will clear this value. May be set to a relative path."})
    private String sdkLocation;
    @CommandLine.Option(names={"-edit", "--editor"}, paramLabel="EDITOR_PATH", description={"Path to an editor to open component .slcc files with. The editor will have to be able to accept a file path as an argument for this shortcut to work. Both Atom and Notepad++ are known to be supported."})
    private String editorLocation;
    @CommandLine.Option(names={"-e", "--examine"}, description={"Indicates that the current configuration file should be printed out, as well as the location it resides it for manual editing if desired/needed."})
    private boolean examine;
    @CommandLine.Option(names={"-p", "--parallel", "--no-cache-update"}, arity="1", description={"Turns off cache updating when an sdk is parsed. This is only intended for situations where multiple cli commands, such as generate, are using the same sdk without utilising the daemon functionality (which renders this option unneeded)"})
    private boolean parallel;
    @CommandLine.Option(names={"-gcc", "--gcc-toolchain"}, paramLabel="GCC_TOOLCHAIN_PATH", description={"Register a gcc toolchain location to be used by the exporter. Input should be the path to the parent directory of the bin and lib folders."})
    private String gccToolchainPath;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.ParentCommand
    private CliRoot root;

    public ICliOutput session() {
        return this.root.feedback(this.cliConfig);
    }

    @Override
    public Integer call() {
        CommandLine.ParseResult pr;
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IPersistedCliConfig config = feedback.config();
        boolean atLeastOne = false;
        boolean persistOnExit = false;
        if (this.sdkLocation != null) {
            atLeastOne = true;
            persistOnExit = true;
            if ("".equals(this.sdkLocation)) {
                config.clear((PersistEntry)CorePersistables.SDK);
                feedback.out().println("sdk cleared");
            } else {
                String realSdkLoc = this.resolvePath(feedback, this.sdkLocation);
                config.set((PersistEntry)CorePersistables.SDK, (Object)realSdkLoc);
                feedback.out().println("sdk was set to " + realSdkLoc);
            }
        }
        if (this.editorLocation != null) {
            atLeastOne = true;
            persistOnExit = true;
            config.set((PersistEntry)CorePersistables.EXTERNAL_APP_EDITOR, (Object)this.editorLocation);
            feedback.out().println("external editor was set to " + this.editorLocation);
        }
        if ((pr = this.spec.commandLine().getParseResult()).hasMatchedOption("-p")) {
            atLeastOne = true;
            persistOnExit = true;
            config.set((PersistEntry)CorePersistables.PARALLEL_MODE, (Object)String.valueOf(this.parallel));
            feedback.out().println("parallel mode was set " + (this.parallel ? "on" : "off"));
        }
        if (this.gccToolchainPath != null) {
            atLeastOne = true;
            persistOnExit = true;
            String realToolchainPath = this.resolvePath(feedback, this.gccToolchainPath);
            ToolchainUtils.registerCliToolchain((String)"gcc", (String)realToolchainPath);
            feedback.out().println("GCC toolchain location was set to " + realToolchainPath);
        }
        if (persistOnExit) {
            try {
                config.persist();
            }
            catch (IOException e) {
                feedback.unifiedLogger().userError("Could not persist configuration: " + e.getMessage(), (Throwable)e);
                feedback.err().println("An error occurred when attempting to save your changes: " + e.getMessage());
            }
        }
        if (this.examine) {
            atLeastOne = true;
            feedback.out().println(config.print());
        }
        if (!atLeastOne) {
            feedback.out().println(config.print());
        }
        return IApplication.EXIT_OK;
    }

    private String resolvePath(ICliOutput feedback, String path) {
        return feedback.resolve(path.trim()).normalize().toString();
    }
}

