/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.comp.ApiPartaker;
import com.silabs.ss.framework.uc.core.api.comp.IRecommendation;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentConfiguration;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.rule.ApiRule;
import com.silabs.ss.framework.uc.core.api.tree.NTreeMutable;
import com.silabs.ss.framework.uc.core.api.tree.TreeMutable;
import com.silabs.ss.framework.uc.core.api.validate.ApiValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.ComponentRule;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.ss.framework.uc.core.api.validate.UcApiValidator;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.ProjectRequiredException;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="graph", description={"Display a dependency tree that approximates the dependency graph of a project. When a component first appears in the tree, its dependencies will be shown, and subsequent appearences will not include them. Particular attention can be called to component(s) with --focus."})
public class UcCliDependencyGraph
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProjectImplicit projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-val", "--validate"}, description={"[Deprecated] Also perform project validation. Components that spawned validation issues will be in red (or marked with * for non-colour consoles) along with a description below what the issue is. This is enabled by default so the option is deprecated."})
    private boolean validate;
    @CommandLine.Option(names={"-foc", "--focus"}, description={"Accepts a comma separated list of component ids (or just one) that should be focused on. Depending on the colour capabilities of the system, attention will be drawn to wherever these components appear in the dependency tree"}, paramLabel="COMPONENT_IDS", split=",")
    private List<String> focus = new ArrayList<String>();
    static final CliColour[] COLOUR_MATCH = new CliColour[]{CliColour.CYAN, CliColour.YELLOW, CliColour.BLUE, CliColour.GREEN, CliColour.MAGENTA};
    static final String[] CHAR_MATCH = new String[]{"+", "*", "@", "#", "=", ".", "~"};
    private static final DisplayableNode DUMMY = new DisplayableNode("", -1);

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        boolean forceOperations = this.force.forceOperations();
        return this.projectBase.loadProject((IUcSdkContent)sdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), true, true, forceOperations).map(p -> this.runGraph((IUcProjectMutable)p, feedback)).orElseThrow(ProjectRequiredException::new);
    }

    private int runGraph(IUcProjectMutable project, ICliOutput feedback) {
        if (this.validate) {
            feedback.out().println("--validate is deprecated. Validation is always toggled on.");
        }
        RenderStrategy strat = UcCliDependencyGraph.pickStrategy(feedback.session());
        HashMultimap failedComponentToMessage = HashMultimap.create();
        for (ApiValidationIssue issue : StreamUtils.iterableOf((Stream)UcApiValidator.validate((IUcComponentContainer)project.ucFramework(), (IUcComponentConfiguration)project))) {
            failedComponentToMessage.put((Object)issue.partaker().id(), (Object)issue.message());
        }
        UcApiUtils.SelectedWithApis selectionData = UcApiUtils.calculateSelected((IUcProject)project);
        IUcComponentConfiguration.SplitSelection split = project.splitByExplicitImplicit((List)selectionData.everythingSelected());
        ImmutableSetMultimap totalRequired = UcApiUtils.totalRequired(Streams.concat((Stream[])new Stream[]{selectionData.trulySelected().stream(), Stream.of(project)}).collect(Collectors.toList()), (ImmutableSetMultimap)selectionData.totalApis());
        TreeContext context = new TreeContext(selectionData, (ImmutableSetMultimap<ApiId, ComponentRule>)totalRequired, this.focus, (Multimap<String, String>)failedComponentToMessage);
        for (ApiPartaker sel : selectionData.everythingSelected()) {
            if (!(sel instanceof IUcComponent)) continue;
            IUcComponent comp = (IUcComponent)sel;
            UcApiUtils.satisfyConditionals((Stream)comp.recommendations().stream(), (Set)selectionData.totalApis().keySet()).forEach(rec -> {
                boolean bl = treeContext.recommended.put((Object)UcCliDependencyGraph.recToDisplayable(rec), (Object)comp.id());
            });
        }
        NTreeMutable parent = new NTreeMutable((Object)DUMMY);
        for (ApiPartaker partaker : Iterables.concat((Iterable)split.explicitlySelected, (Iterable)split.nonComponentSelections)) {
            DisplayableNode explicitNode = new DisplayableNode(partaker.id(), 0);
            if (partaker instanceof IUcProject) {
                explicitNode.project = true;
            }
            TreeMutable explicit = parent.add((Object)explicitNode);
            UcCliDependencyGraph.buildNextLevel((TreeMutable<DisplayableNode>)explicit, 1, context, partaker);
        }
        parent.iterator().forEachRemaining(node -> {
            String rendered = strat.renderNode((DisplayableNode)node);
            feedback.out().println(rendered);
        });
        return IApplication.EXIT_OK;
    }

    private static String recToDisplayable(IRecommendation rec) {
        return rec.recommendedId() + rec.from().map(f -> " from " + f).orElse("");
    }

    private static RenderStrategy pickStrategy(CliSessionData session) {
        return session.isColour() ? Colour.INSTANCE : NoColour.INSTANCE;
    }

    private static void buildNextLevel(TreeMutable<DisplayableNode> parent, int level, TreeContext context, ApiPartaker onLevel) {
        Set allParents = parent.parents().map(n -> ((DisplayableNode)n.get()).name).collect(Collectors.toSet());
        ImmutableSetMultimap who = UcApiUtils.whoIsNeeded((ApiPartaker)onLevel, (ImmutableSetMultimap)context.selectionData.totalApis(), context.totalRequired);
        String parentName = ((DisplayableNode)parent.get()).name;
        if (context.componentToValidationIssue.containsKey((Object)parentName)) {
            ((DisplayableNode)parent.get()).issues = context.componentToValidationIssue.get((Object)parentName).stream().sorted().collect(Collectors.toList());
        }
        List sorted = who.keySet().stream().sorted((p1, p2) -> p1.displayableId().compareTo(p2.displayableId())).toList();
        for (ApiPartaker next : sorted) {
            int focus;
            String nextName = next.displayableId();
            DisplayableNode node = new DisplayableNode(nextName, level);
            boolean newComponent = context.alreadyHit.add(nextName);
            if (!newComponent && next.requiredApis().count() != 0L) {
                node.showCaret = true;
            }
            if (allParents.contains(nextName)) {
                node.cycle = true;
            }
            ImmutableSet satisfiers = who.get((Object)next);
            for (ApiRule rule : satisfiers) {
                String ruleId = rule.getApi().id();
                if (nextName.equals(ruleId)) continue;
                node.provides.add(ruleId);
            }
            node.focus = focus = UcCliDependencyGraph.intContains(nextName, context.focused);
            if (context.recommended.containsKey((Object)nextName)) {
                node.recommended = context.recommended.get((Object)nextName).stream().collect(Collectors.joining(", "));
            }
            TreeMutable child = parent.add((Object)node);
            if (!newComponent) continue;
            UcCliDependencyGraph.buildNextLevel((TreeMutable<DisplayableNode>)child, level + 1, context, next);
        }
    }

    private static int intContains(String name, List<String> focus) {
        int found = -1;
        int index = 0;
        for (String f : focus) {
            if (name.equals(f)) {
                found = index;
                break;
            }
            ++index;
        }
        return found;
    }

    private static String computePadding(DisplayableNode node, boolean colour) {
        String paddingChar = colour || node.focus < 0 ? " " : CHAR_MATCH[node.focus % CHAR_MATCH.length];
        String padding = Strings.repeat((String)paddingChar, (int)(node.level * 2)) + (node.level != 0 ? "- " : "");
        return padding;
    }

    private static String computeIssues(String padding, DisplayableNode node) {
        if (!node.showCaret && !node.issues.isEmpty()) {
            String issuePadding = System.lineSeparator() + padding + " ! ";
            return node.issues.stream().collect(Collectors.joining(issuePadding, issuePadding, ""));
        }
        return "";
    }

    private static enum Colour implements RenderStrategy
    {
        INSTANCE;


        @Override
        public String renderNode(DisplayableNode node) {
            if (node.level < 0) {
                return "";
            }
            String padding = UcCliDependencyGraph.computePadding(node, true);
            String caret = node.showCaret ? " ^ " : " ";
            String cycle = node.cycle ? CliColour.GREEN.applyColourANSI("[Cycle]") : "";
            String project = node.project ? CliColour.GREEN.applyColourANSI("[Project]") : "";
            String rec = node.recommended == null ? "" : CliColour.YELLOW.applyColourANSI(" Recommended! (" + node.recommended + ")");
            String nodeName = node.focus < 0 ? node.name : COLOUR_MATCH[node.focus % COLOUR_MATCH.length].applyColourANSI(node.name);
            String issues = UcCliDependencyGraph.computeIssues(padding, node);
            if (!issues.isBlank()) {
                issues = CliColour.RED.applyColourANSI(issues);
            }
            return padding + nodeName + caret + (node.provides.isEmpty() ? "" : CliColour.MAGENTA.applyColourANSI(node.provides.stream().collect(Collectors.joining(", ", "(", ")")))) + cycle + project + rec + issues;
        }
    }

    private static final class DisplayableNode {
        final String name;
        final int level;
        boolean showCaret;
        boolean cycle;
        boolean project;
        int focus;
        List<String> provides = new ArrayList<String>();
        List<String> issues = new ArrayList<String>();
        String recommended;

        DisplayableNode(String name, int level) {
            this.name = name;
            this.level = level;
        }
    }

    private static enum NoColour implements RenderStrategy
    {
        INSTANCE;


        @Override
        public String renderNode(DisplayableNode node) {
            if (node.level < 0) {
                return "";
            }
            String padding = UcCliDependencyGraph.computePadding(node, false);
            String caret = node.showCaret ? " ^ " : " ";
            String cycle = node.cycle ? "[Cycle]" : "";
            String project = node.project ? "[Project]" : "";
            String rec = node.recommended == null ? "" : " Recommended! (" + node.recommended + ")";
            Object issues = UcCliDependencyGraph.computeIssues(padding, node);
            if (!Strings.isNullOrEmpty((String)issues)) {
                issues = " ! Issues detected: " + (String)issues;
            }
            return padding + node.name + caret + (node.provides.isEmpty() ? "" : node.provides.stream().collect(Collectors.joining(", ", "(", ")"))) + cycle + project + rec + (String)issues;
        }
    }

    private static interface RenderStrategy {
        public String renderNode(DisplayableNode var1);
    }

    private static final class TreeContext {
        final Set<String> alreadyHit = new HashSet<String>();
        final UcApiUtils.SelectedWithApis selectionData;
        final ImmutableSetMultimap<ApiId, ComponentRule> totalRequired;
        final List<String> focused;
        final Multimap<String, String> componentToValidationIssue;
        final Multimap<String, String> recommended = HashMultimap.create();

        TreeContext(UcApiUtils.SelectedWithApis selDat, ImmutableSetMultimap<ApiId, ComponentRule> req, List<String> focused, Multimap<String, String> componentToValidationIssue) {
            this.selectionData = selDat;
            this.totalRequired = req;
            this.focused = focused;
            this.componentToValidationIssue = componentToValidationIssue;
        }
    }
}

