/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.thread.SilabsThreadFactory;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcProjectFramework;
import com.silabs.ss.framework.uc.core.api.UcProjectFramework;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.platform.api.descriptor.core.model.util.StudioModelUtils;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.IUcExampleResult;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.model.UcExampleDefinition;
import com.silabs.uc.cli.internal.model.UcExampleProjectResult;
import com.silabs.uc.cli.internal.model.UcExampleResults;
import com.silabs.uc.cli.internal.model.UcExampleWorkspaceResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="examples", description={"Commands for the Project Configuration Tools examples found in an SDK"})
public final class UcCliExamples
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-fdir", "--filter-dir"}, description={"Only run for the selected directories. Generate will not run for this case."}, paramLabel="FILTER_DIRECTORY_LIST", split=",")
    Set<String> filterDirectories = new HashSet<String>();
    @CommandLine.Option(names={"-fpkg", "--filter-pkg"}, description={"Only run for the selected packages"}, paramLabel="FILTER_PACKAGE_LIST", split=",")
    Set<String> filterPackages = new HashSet<String>();
    @CommandLine.Option(names={"-fqual", "--filter-quality"}, description={"Only run for the selected qualities"}, paramLabel="FILTER_QUALITY_LIST", split=",")
    Set<String> filterQuality = new HashSet<String>();
    @CommandLine.Option(names={"-g", "--generate"}, description={"Generate the examples and demos based on the detected slcp files"})
    boolean generate;
    @CommandLine.Option(names={"-pkgmap", "--package-map"}, paramLabel="PACKAGE_MAPPING_PATH", description={"Path to the package mapping file that defines where each generated fileshould be added to for every package type."})
    String packageMap;
    @CommandLine.Option(names={"-l", "--list"}, paramLabel="LIST_TYPE", description={"List the detected slcp, slcw, quality, or package for all slc example files found in the SDK. Valid values: ${COMPLETION-CANDIDATES}"})
    ListType listType;
    @CommandLine.Option(names={"-pkgcompat", "--package-compatibility"}, description={"Use the compatibility stored in the generated examples metadata file. This is fast but not entirely correct. It cannot be selected at the same time as --calculated_compatibility."})
    boolean usePackageCompatibility;
    @CommandLine.Option(names={"-calccompat", "--calculated-compatibility"}, description={"Use the compatibility generated from the valid set of boards. This is *slow*. It cannot be selected at the same time as --package_compatibility."})
    boolean useCalcCompatibility;
    @CommandLine.Option(names={"-scompat", "--show-compatibility"}, description={"When using the print or list command, this will also generate and print the project compatibilities."})
    boolean showCompatibility;
    @CommandLine.Option(names={"-p", "--print"}, description={""})
    boolean print;
    private static final String NL = System.lineSeparator();

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runExamples((IUcSdk)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    public int runExamples(IUcSdk sdk, ICliOutput feedback) {
        block12: {
            Set<Path> filterDirs = this.filterDirectories.stream().map(d -> {
                Path resolved = feedback.resolve((String)d);
                if (Files.exists(resolved, new LinkOption[0])) {
                    return resolved;
                }
                return sdk.framework().directory().toPath().resolve((String)d);
            }).collect(Collectors.toSet());
            Set<String> filterPkgs = this.filterPackages.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            Set<String> filterQuals = this.filterQuality.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            if (!this.generate && !this.print && this.listType == null) {
                feedback.err().println("No arguments specified!");
            }
            boolean calcCompat = this.useCalcCompatibility;
            if (this.useCalcCompatibility && this.usePackageCompatibility) {
                feedback.err().print("Both package and calculation compatibility cannot be selected at the same time.");
                this.spec.commandLine().usage(feedback.err());
            }
            ExecutorService threadEngine = Executors.newFixedThreadPool(64, SilabsThreadFactory.withName((String)"Slc-Examples-Operation-Thread").setDaemon(true).create());
            try {
                try {
                    UcExampleDefinition exampleDef = this.packageMap == null ? UcExampleDefinition.loadDefault((IUcSdkContent)sdk) : UcExampleDefinition.load((IUcSdkContent)sdk, feedback.resolve(this.packageMap));
                    IUcAdditionalFramework virtualBoardsExtension = IUcAdditionalFramework.createWithCustoms((IUcFramework)sdk.framework(), (String)"virtual_boards", exampleDef.getVirtualBoards());
                    IUcProjectFramework componentFramework = UcProjectFramework.createWithSdkExtensions((IUcFramework)sdk.framework(), (Iterable)ImmutableList.of((Object)virtualBoardsExtension), (boolean)false);
                    feedback.err().print(String.join((CharSequence)"\n", exampleDef.warnings()));
                    Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping = new UcExampleResults((IUcSdkContent)sdk, (IUcFramework)componentFramework, exampleDef, calcCompat, feedback, threadEngine).load(filterDirs, filterPkgs, filterQuals);
                    if (this.print) {
                        this.printExampleData(feedback, exampleMapping, this.showCompatibility, calcCompat);
                    }
                    if (this.listType != null) {
                        this.printContentListing(exampleMapping, this.listType, feedback);
                    }
                    if (this.generate) {
                        try {
                            this.runGeneration(feedback, exampleDef, exampleMapping);
                        }
                        catch (IOException e) {
                            feedback.unifiedLogger().userError("Errors generating example project: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    feedback.unifiedLogger().userError("Errors loading package mappings: " + e.getMessage(), (Throwable)e);
                    threadEngine.shutdown();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                threadEngine.shutdown();
                throw throwable;
            }
            threadEngine.shutdown();
        }
        feedback.out().flush();
        return IApplication.EXIT_OK;
    }

    private void runGeneration(ICliOutput feedback, UcExampleDefinition exampleDef, Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping) throws IOException {
        for (Map.Entry<String, Multimap<ComponentQuality, IUcExampleResult>> pkgQualityProject : exampleMapping.entrySet()) {
            String pkg = pkgQualityProject.getKey();
            File propFile = exampleDef.propFile(pkg);
            if (propFile == null) continue;
            ArrayList<Path> generatedFiles = new ArrayList<Path>();
            for (ComponentQuality quality : pkgQualityProject.getValue().keySet()) {
                String templatesName = (pkg + "_" + quality.toString() + "_templates.xml").replace(" ", "_").toLowerCase(Locale.ROOT);
                Path templateFile = propFile.getParentFile().toPath().resolve(templatesName);
                generatedFiles.add(templateFile);
                List descs = pkgQualityProject.getValue().get((Object)quality).stream().map(p -> p.createTemplate(templateFile)).filter(Objects::nonNull).collect(Collectors.toList());
                StudioModelUtils.storeMDescriptorsToFile((File)templateFile.toFile(), descs);
                feedback.out().print("Generating " + templateFile.toString() + NL);
            }
            this.writeProperties(propFile, generatedFiles, feedback);
        }
    }

    private void writeProperties(File propFile, Collection<Path> generatedFiles, ICliOutput feedback) {
        List<String> lines;
        Path propPath = propFile.toPath();
        try {
            lines = Files.readAllLines(propPath);
        }
        catch (IOException iOException) {
            feedback.err().print("Failed to update properties file at " + String.valueOf(propFile));
            return;
        }
        Path propFolder = propPath.getParent();
        Collection templFiles = generatedFiles.stream().map(propFolder::relativize).map(Path::toString).collect(Collectors.toList());
        ArrayList<Object> newLines = new ArrayList<Object>();
        boolean found = false;
        for (String line : lines) {
            if (line.startsWith("prop.file.templatesFile=")) {
                found = true;
                StringBuilder addedContent = new StringBuilder();
                for (String templFile : templFiles) {
                    if (line.contains(templFile)) continue;
                    addedContent.append(templFile).append(" ");
                }
                String newLine = line;
                if (addedContent.length() != 0) {
                    newLine = newLine.replace("prop.file.templatesFile=", "prop.file.templatesFile=" + addedContent.toString());
                }
                newLines.add(newLine);
                continue;
            }
            newLines.add(line);
        }
        if (!found) {
            newLines.add("\nprop.file.templatesFile=" + TextUtils.catenateStrings((Collection)templFiles, (String)" ") + "\n");
        }
        try {
            Files.write(propPath, newLines, new OpenOption[0]);
        }
        catch (IOException iOException) {
            feedback.err().print("Failed to update properties file at " + String.valueOf(propFile));
            return;
        }
    }

    private void printExampleData(ICliOutput feedback, Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping, boolean showCompat, boolean calcCompat) {
        StringBuilder errorStr = new StringBuilder();
        for (String errorTitle : List.of("Workspace loading failures", "Project loading failures")) {
            Multimap<ComponentQuality, IUcExampleResult> errors = exampleMapping.remove(errorTitle);
            if (errors == null || errors.isEmpty()) continue;
            if (errorStr.length() > 0) {
                errorStr.append(NL).append(NL);
            }
            errorStr.append(errorTitle).append(NL);
            errors.values().forEach(e -> {
                errorStr.append(" - ").append(e.file()).append(NL);
                e.errors().forEach(p -> {
                    StringBuilder stringBuilder2 = errorStr.append("  = ").append(p.message()).append(NL);
                });
            });
        }
        feedback.out().print(errorStr.toString().trim());
        if (showCompat) {
            if (calcCompat) {
                feedback.out().print("Calculating board compatibility. This will take some time..." + NL);
                feedback.out().flush();
            }
            exampleMapping.values().parallelStream().flatMap(m -> m.values().stream()).forEach(IUcExampleResult::boardCompat);
        }
        if (!exampleMapping.isEmpty()) {
            this.generatePrintOutput(exampleMapping, feedback, showCompat);
        } else {
            feedback.out().print("No slcp files found");
        }
    }

    private void generatePrintOutput(Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping, ICliOutput feedback, boolean showCompat) {
        for (Map.Entry<String, Multimap<ComponentQuality, IUcExampleResult>> pkgMap : exampleMapping.entrySet()) {
            String packaged = pkgMap.getKey();
            feedback.out().append("Package: ").append(packaged).append(NL);
            Multimap<ComponentQuality, IUcExampleResult> qualityMap = pkgMap.getValue();
            for (ComponentQuality quality : qualityMap.keySet()) {
                feedback.out().append("  Quality: ").append(String.valueOf(quality)).append(NL);
                for (IUcExampleResult example : qualityMap.get((Object)quality)) {
                    feedback.out().append("      ").append(example.title()).append(": ").append(example.name()).append(" - ").append(String.valueOf(example.file())).append(NL);
                    if (showCompat) {
                        feedback.out().append("              - Board Compatibility: ").append(example.boardCompat()).append(NL);
                        feedback.out().append("              - Part Compatibility: ").append(example.partCompat()).append(NL);
                        feedback.out().append("              - Toolchain Compatibility: ").append(example.toolchainCompat()).append(NL);
                        feedback.out().append("              - IDE Compatibility: ").append(example.ideCompatibility()).append(NL);
                    }
                    example.warnings().forEach(p -> {
                        PrintStream printStream = feedback.out().append("       - ").append(p.message()).append(NL);
                    });
                    feedback.out().flush();
                }
            }
        }
    }

    private void printContentListing(Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping, ListType listType, ICliOutput feedback) {
        feedback.out().print((switch (listType) {
            case ListType.slcp -> this.exampleMappingStream(exampleMapping, UcExampleProjectResult.class);
            case ListType.slcw -> this.exampleMappingStream(exampleMapping, UcExampleWorkspaceResult.class);
            case ListType.pkg -> exampleMapping.keySet().stream();
            case ListType.quality -> exampleMapping.values().stream().map(Multimap::keySet).flatMap(Collection::stream).sorted((a, b) -> Integer.compare(a.ordinal(), b.ordinal())).map(Enum::toString);
            default -> throw new RuntimeException("Enum added to ListType that is not handled: " + String.valueOf((Object)listType));
        }).distinct().collect(Collectors.joining(NL)));
    }

    private Stream<String> exampleMappingStream(Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping, Class<?> clazz) {
        return exampleMapping.values().stream().map(Multimap::values).flatMap(Collection::stream).filter(clazz::isInstance).filter(IUcExampleResult::isValid).map(IUcExampleResult::file).map(File::getAbsolutePath);
    }

    private static enum ListType {
        slcp,
        slcw,
        pkg,
        quality;

    }
}

