/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.command.util.FoundComponent;
import com.silabs.uc.cli.internal.command.util.UcCliUtils;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="where", description={"print the file location of the input component"})
public final class UcCliWhere
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProject projectBase;
    @CommandLine.Mixin
    private CliExtensionMixin ifExt;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Parameters(index="0", description={"component id to search for"}, paramLabel="COMPONENT_ID")
    String componentId;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runWhere((IUcSdk)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    private int runWhere(IUcSdk sdk, ICliOutput feedback) {
        IUcProject project = this.projectBase.loadProject((IUcSdkContent)sdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), false, false, this.force.forceOperations()).orElse(null);
        Optional<IUcComponent> found = UcCliUtils.findComponent(this.componentId, this.ifExt, sdk, project, feedback).map(FoundComponent::component);
        if (found.isPresent()) {
            feedback.out().println(found.get().metaSource().reportedLocation());
            return IApplication.EXIT_OK;
        }
        feedback.out().println("Component " + this.componentId + " does not exist in this sdk");
        return -1;
    }
}

