/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.uc.api.core.IAdapterPackAc;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.setup.ISetupId;
import com.silabs.ss.framework.uc.core.api.setup.SetupId;
import com.silabs.ss.framework.uc.core.api.setup.UcSetupModel;
import com.silabs.ss.framework.uc.core.internal.setup.acts.apack.AdapterPackAcUtils;
import com.silabs.ss.platform.api.apack.core.model.FunctionType;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPack;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunction;
import com.silabs.ss.platform.api.descriptor.core.IDescribableVersionedEntity;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.SdkDescriptorWithPath;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="zclConfigurator", hidden=true, description={"Temporary command to show the Zap version info to prevent GSDK build failures."})
public class UcCliZclConfiguratorTemp
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliExternalTools cliExtTools;
    @CommandLine.Mixin
    private CliSdk sdkCmd;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdk;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"version"})
    boolean versionCmd;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        if (this.cliExtTools.customsDefined()) {
            feedback.err().println("zclConfigurator command is not supported using SLT frameworks. Please use `adapter-packs`");
            return 1;
        }
        if (!this.versionCmd) {
            feedback.err().println("Only the 'version' command is supported for 'zclConfigurator'");
            return 1;
        }
        return this.runZapVersioning(feedback);
    }

    private Integer runZapVersioning(ICliOutput feedback) {
        String sdkId = this.sdkCmd.loadSdk(feedback).flatMap(SdkDescriptorWithPath::realSdk).map(IDescribableVersionedEntity::getId).orElse("%none%");
        IAdapterPack apack = UcSetupModel.instance().setup((ISetupId)SetupId.get((String)"apack_zclConfigurator")).map(arg_0 -> ((Caster)Caster.with(IAdapterPackAc.class)).cast(arg_0)).map(p -> p.apack(sdkId)).filter(Objects::nonNull).orElse(null);
        if (apack == null) {
            feedback.err().println("No tool for 'zclConfigurator' found");
            return 1;
        }
        IAdapterPackFunction versionFunc = apack.function(FunctionType.make((String)"version"));
        if (versionFunc == null) {
            feedback.err().println("'zclConfigurator' tool does not define a 'version' function");
            return 1;
        }
        feedback.out().println("**WARNING** This API is deprecated and slated for removal! Please use `adapter-packs` instead!");
        try {
            Integer exitCode = AdapterPackAcUtils.runApackJob((IAdapterPackFunction)versionFunc, Map.of(), (OutputStream)feedback.out(), (OutputStream)feedback.err(), (IUnifiedLogger)feedback.unifiedLogger(), null, null);
            if (exitCode != 0) {
                feedback.err().println("Error running command. Exit code: " + String.valueOf(exitCode));
                Integer n = exitCode;
                return n;
            }
            Integer n = exitCode;
            return n;
        }
        catch (Exception e) {
            feedback.err().println("Unexpected Exception during command line processing: " + e.getMessage());
            e.printStackTrace(feedback.err());
            Integer n = 1;
            return n;
        }
        finally {
            feedback.err().flush();
        }
    }
}

