/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.exception;

import com.silabs.uc.cli.internal.command.exception.CliMessageOnlyException;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.PrintStream;
import picocli.CommandLine;

public final class CliExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    private final ICliOutput feedback;

    public CliExceptionHandler(ICliOutput feedback) {
        this.feedback = feedback;
    }

    public int handleExecutionException(Exception except, CommandLine cmd, CommandLine.ParseResult pr) throws Exception {
        PrintStream err = this.feedback.err();
        if (except instanceof CliMessageOnlyException) {
            err.println(except.getMessage());
        } else {
            err.println("An unexpected error occurred executing a command line operation. Please see logs for stack trace.");
            err.println("Error: " + except.getMessage());
            this.feedback.unifiedLogger().internalError("Command line exception " + except.getMessage(), (Throwable)except);
        }
        return cmd.getExitCodeExceptionMapper().getExitCode((Throwable)except);
    }
}

