/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.Result;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.uc.api.project.IUcContextManager;
import com.silabs.ss.framework.uc.api.project.UcContextRequest;
import com.silabs.ss.framework.uc.core.api.ConfigOverride;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcBackingStore;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcProjectFramework;
import com.silabs.ss.framework.uc.core.api.UcProjectFramework;
import com.silabs.ss.framework.uc.core.api.comp.IUcProjectComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcContext;
import com.silabs.ss.framework.uc.core.api.context.IUcContextSessionConfiguration;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.UcConfigurationException;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.meta.IMetaParseStatus;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssue;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssueUtils;
import com.silabs.ss.framework.uc.core.api.meta.exception.UcParsingException;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.ss.framework.uc.core.api.model.slcw.ISlcwRegistryMutable;
import com.silabs.ss.framework.uc.core.api.model.slcw.SlcwRegistryManager;
import com.silabs.ss.framework.uc.core.api.project.state.ISessionApacks;
import com.silabs.ss.framework.uc.core.internal.api.context.IUcSetupSessionStrategy;
import com.silabs.ss.framework.uc.core.internal.api.context.OriginalSdkBasedApackLoading;
import com.silabs.ss.framework.uc.core.internal.api.context.SltApackLoading;
import com.silabs.ss.framework.uc.core.internal.api.context.UcContextSessionConfiguration;
import com.silabs.ss.framework.uc.core.internal.context.UcContext;
import com.silabs.ss.framework.uc.core.internal.project.UcContextManager;
import com.silabs.ss.platform.api.rcp.core.CommonSplitters;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.command.util.CliProjectUtils;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

public class CliProject {
    public static final ImmutableList<String> PROJECT_OPTIONS = ImmutableList.of((Object)"-p", (Object)"--project-file");
    @CommandLine.Mixin
    private CliExternalTools extTools;
    @CommandLine.Mixin
    private CliWithinWithout withinWithout;
    @CommandLine.Option(names={"-p", "--project-file"}, paramLabel="PROJECT_SLCP", description={"Location of .slcp project file for use with this operation. This option can be ommitted if the project is referenced via a positional parameter."})
    private String projectLocation;
    @CommandLine.Option(names={"--configuration"}, paramLabel="CONFIGURATION_OVERRIDE_MAP", description={"Provides the same function as 'configuration' in the .slcp, but command line options take precedence. Takes a comma separated list of configuration changes. A configuration change is the name of the configuration, a ':', and the value it should actually take. Because conditions are not used, the same configurable cannot be referenced on the command line more than once."})
    private String configurationOverrides;
    public static final ImmutableList<String> GEN_DEST_NAMES = ImmutableList.of((Object)"-d", (Object)"--export-destination");
    @CommandLine.Option(names={"-d", "--export-destination"}, paramLabel="DESTINATION", description={"Location that the generated project should go. If not provided, then the slcp or slcw location will be used. Generation location is used even for non-generating commands as information there can still contribute to project state."})
    private String destination;

    public static CliProject createDirectly(String projectLocation, CliWithinWithout withinWithout, CliExternalTools extTools) {
        CliProject projectCli = new CliProject();
        projectCli.extTools = extTools;
        projectCli.projectLocation = projectLocation;
        projectCli.withinWithout = withinWithout;
        return projectCli;
    }

    public String destination() {
        return this.destination;
    }

    public List<String> withinComponents() {
        return this.withinWithout.withinComponents();
    }

    public String projectLocation() {
        return this.projectLocation;
    }

    public CliExternalTools extTools() {
        return this.extTools;
    }

    public Optional<IUcProjectMutable> loadProject(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDirectory, boolean required, boolean force) {
        return this.loadProject(sdk, feedback, sltFeatures, forceReasonableGenDirectory, required, false, force);
    }

    public Optional<IUcProjectMutable> loadProject(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDirectory, boolean required, boolean skipModify, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDirectory, required, false, skipModify, force).map(ProjectContainer::project);
    }

    private Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean skipModify, boolean force) {
        return this.loadProjectContainerWithLocation(this.projectLocation, sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, true, skipModify, force);
    }

    Optional<ProjectContainer> loadProjectContainerWithLocation(String finalProjectLocation, IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean allowMissingComponents, boolean skipModify, boolean force) {
        return this.loadProjectContainerWithLocation(finalProjectLocation, sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, allowMissingComponents, skipModify, force, false);
    }

    Optional<ProjectContainer> loadProjectContainerWithLocation(String finalProjectLocation, IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean allowMissingComponents, boolean skipModify, boolean force, boolean ignoreWarnings) {
        if (finalProjectLocation == null) {
            if (required) {
                feedback.err().println("Project location was not supplied.");
            }
            return Optional.empty();
        }
        Path exportDestination = this.destination != null ? feedback.resolve(this.destination) : null;
        try {
            Path projFile;
            Result<ProjectContainer, UcException> ucProj;
            if (!forceReasonableGenDestination) {
                exportDestination = Files.createTempDirectory("emptyGen", new FileAttribute[0]);
            }
            if (!(ucProj = this.loadProject(projFile = feedback.resolve(finalProjectLocation), exportDestination, sdk, feedback, sltFeatures, failOnWarnings, allowMissingComponents, skipModify, force, ignoreWarnings)).isLeft()) {
                UcException exception = (UcException)ucProj.error();
                feedback.unifiedLogger().internalError(exception.getMessage(), (Throwable)exception);
                feedback.err().println("Project could not be loaded. Refer to earlier errors or logs for details.");
                return Optional.empty();
            }
            assert (ucProj.isLeft());
            ProjectContainer projContainer = (ProjectContainer)ucProj.left();
            return Optional.of(projContainer);
        }
        catch (UcConfigurationException | UcParsingException | IOException e) {
            feedback.unifiedLogger().userError("Could not load project due to " + e.getMessage(), e);
            return Optional.empty();
        }
    }

    public Result<ProjectContainer, UcException> loadProject(Path projFile, Path genDir, IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean failOnWarnings, boolean allowMissingComponents, boolean skipModify, boolean force, boolean ignoreWarnings) throws UcConfigurationException {
        Path realProjFile;
        Path projFileResolved;
        if (!Files.exists(projFile, new LinkOption[0])) {
            return Result.err((Object)((Object)new UcParsingException("Cannot load project file that doesn't exist: " + String.valueOf(projFile))));
        }
        Path path = projFileResolved = !projFile.isAbsolute() ? projFile.toAbsolutePath() : projFile;
        if (Files.isDirectory(projFileResolved, new LinkOption[0]) && projFileResolved.getParent() == null) {
            return Result.err((Object)((Object)new UcParsingException("Cannot get parent folder for slcp file " + String.valueOf(projFileResolved))));
        }
        if (Files.isDirectory(projFileResolved, new LinkOption[0])) {
            Result<Path, UcParsingException> except = CliProject.validateSlcpDir(projFileResolved, feedback);
            if (!except.isLeft()) {
                return Result.err((Object)((UcException)except.right()));
            }
            realProjFile = (Path)except.left();
            feedback.out().println("Using slcp at " + String.valueOf(realProjFile));
        } else {
            realProjFile = projFile;
        }
        ImmutableList<Path> extensionPaths = sltFeatures.calculatedExtensionLocations();
        IUcContext context = this.loadContext(genDir, sdk, realProjFile, extensionPaths != null, feedback);
        return this.loadProjectFromContext(context, (List<Path>)extensionPaths, failOnWarnings, allowMissingComponents, force, skipModify, ignoreWarnings, feedback);
    }

    public Result<ProjectContainer, ? extends UcException> loadProjectFromContext(IUcContext context, SltSdkFeatures sltFeatures, boolean failOnWarnings, boolean allowMissingComponents, boolean force, ICliOutput feedback) {
        ImmutableList<Path> extPaths = sltFeatures.calculatedExtensionLocations();
        return this.loadProjectFromContext(context, (List<Path>)extPaths, failOnWarnings, allowMissingComponents, force, false, false, feedback);
    }

    public Result<ProjectContainer, UcException> loadProjectFromContext(IUcContext context, List<Path> extensionPaths, boolean failOnWarnings, boolean allowMissingComponents, boolean force, boolean skipModify, boolean ignoreWarnings, ICliOutput feedback) {
        IUcProjectMutable proj;
        if (context == null) {
            return Result.err((Object)((Object)new UcParsingException("Cannot obtain a context -- sdk is not available")));
        }
        context.projectState().setWarnOnLoad(false);
        try {
            proj = (IUcProjectMutable)context.setupData(IUcProject.SETUP_ID);
        }
        catch (UcException e) {
            feedback.err().println("Errors loading project: Aborting.");
            feedback.err().println(e.getMessage());
            return Result.err((Object)((Object)e));
        }
        IMetaParseStatus parseStatus = proj.parseStatus();
        if (parseStatus.hasError()) {
            feedback.err().println("Errors loading project: Aborting.");
            parseStatus.errors().forEach(error -> context.log().userError(" - " + error.message(), (Throwable)error.cause().orElse(null)));
            return Result.err((Object)((Object)new UcParsingException("Engine errors: see log")));
        }
        if (!ignoreWarnings && parseStatus.hasWarnings()) {
            String errorStr;
            if (!(force || allowMissingComponents || (errorStr = ParseIssueUtils.stringifyForCli(parseStatus.warnings().filter(p -> p.severity() >= 1))).isEmpty())) {
                context.log().userError("Errors loading project: Refusing to continue. Specify '--force' if these issues should be ignored.\n" + errorStr, null);
                return Result.err((Object)((Object)new UcParsingException("Engine errors: see log")));
            }
            StringBuilder sb = new StringBuilder("Warnings loading project: \n");
            sb.append(ParseIssueUtils.stringifyForCli((Stream)parseStatus.warnings()));
            context.log().userWarning(sb.toString(), null);
            if (failOnWarnings) {
                return Result.err((Object)((Object)new UcParsingException("Instructed to fail project load on warnings. ")));
            }
        }
        try {
            this.runCliProjectModifications(proj, extensionPaths, false, force, skipModify, feedback);
        }
        catch (UcConfigurationException e) {
            return Result.err((Object)((Object)new UcException((Throwable)e)));
        }
        return Result.ok((Object)new ProjectContainer(proj, (ImmutableList<ParseIssue>)((ImmutableList)parseStatus.warnings().collect(ImmutableList.toImmutableList()))));
    }

    public boolean runCliProjectModifications(IUcProjectMutable project, SltSdkFeatures sltFeatures, boolean ignoreInstances, boolean force, boolean skipModify, ICliOutput feedback) throws UcConfigurationException {
        return this.runCliProjectModifications(project, (List<Path>)sltFeatures.calculatedExtensionLocations(), ignoreInstances, force, skipModify, feedback);
    }

    public boolean runCliProjectModifications(IUcProjectMutable project, List<Path> extensionPaths, boolean ignoreInstances, boolean force, boolean skipModify, ICliOutput feedback) throws UcConfigurationException {
        IUcFramework framework = project.ucFramework();
        if (extensionPaths != null) {
            framework = this.updateProjectFramework(project, extensionPaths, feedback);
        }
        if (skipModify) {
            return true;
        }
        Set<IUcProjectComponent> addedComps = CliProjectUtils.computeComponentList(this.withinWithout.withinComponents(), ignoreInstances, force, framework, feedback);
        Set<IUcProjectComponent> thoseWithout = CliProjectUtils.computeComponentList(this.withinWithout.withoutComponents(), true, force, framework, feedback);
        for (IUcProjectComponent without : thoseWithout) {
            boolean alsoPartOfWith = addedComps.remove(without);
            if (alsoPartOfWith) continue;
            List<IConditional> resolvedComps = Stream.concat(project.selectedProjectComponents(), Stream.of(without).map(IConditional::unconditional)).filter(c -> Objects.equals(c.data(), without)).toList();
            project.removeProjectComponents(resolvedComps);
        }
        project.addUnconditionalComponents(addedComps.stream());
        if (this.configurationOverrides != null) {
            List projectOverrides = project.configurationOverrides();
            List<Pair<String, String>> cmdOverrides = CliProject.computeOverrides(this.configurationOverrides, feedback);
            Iterator iter = projectOverrides.iterator();
            while (iter.hasNext()) {
                ConfigOverride projOverride = (ConfigOverride)((IConditional)iter.next()).data();
                for (Pair<String, String> cmdOverride : cmdOverrides) {
                    if (!((String)cmdOverride.first()).equals(projOverride.name())) continue;
                    iter.remove();
                }
            }
            List replacementOverrides = cmdOverrides.stream().map(cmd -> IConditional.unconditional((Object)ConfigOverride.createForAnyFile((String)((String)cmd.first()), (String)((String)cmd.second())))).collect(Collectors.toList());
            projectOverrides.addAll(0, replacementOverrides);
        }
        return true;
    }

    private IUcFramework updateProjectFramework(IUcProjectMutable project, List<Path> extensionPaths, ICliOutput feedback) throws UcConfigurationException {
        IUcFramework originalFramework = project.ucFramework();
        ArrayList<IUcAdditionalFramework> newFrameworks = new ArrayList<IUcAdditionalFramework>();
        ExecutorService parsePool = Executors.newSingleThreadExecutor();
        project.clearRequestedSdkExtensions();
        for (Path possibleRaw : extensionPaths) {
            Path possibleNormalised = possibleRaw.normalize();
            Path extLocation = CliSdk.checkForExtension(possibleNormalised, feedback);
            if (extLocation == null) {
                String error = "Passed extension " + String.valueOf(possibleNormalised) + " does not map to an .slce file or folder containing an .slce file. Abandoning command.";
                feedback.err().println(error);
                throw new UcConfigurationException(error);
            }
            try {
                Optional<CliSdk.RequestedSdkExtension> additionalFrameworkToUse = CliSdk.loadSlce(extLocation, originalFramework, parsePool, feedback);
                if (additionalFrameworkToUse.isEmpty()) {
                    throw new UcConfigurationException("Abandoning command: could not load a requested extension: " + String.valueOf(extLocation));
                }
                CliSdk.RequestedSdkExtension newFrameworkExt = additionalFrameworkToUse.get();
                newFrameworks.add(newFrameworkExt.extFramework());
                project.addRequestedSdkExtension(newFrameworkExt.id());
            }
            catch (IOException e) {
                throw new UcConfigurationException("Could not modify project as requested due to: " + e.getMessage(), (Throwable)e);
            }
        }
        if (originalFramework instanceof IUcProjectFramework) {
            IUcProjectFramework projFramework = (IUcProjectFramework)originalFramework;
            originalFramework = projFramework.parentFramework();
        }
        IUcProjectFramework modifiedFramework = UcProjectFramework.createWithSdkExtensions((IUcFramework)originalFramework, newFrameworks, (boolean)false);
        project.setUcFramework(modifiedFramework);
        return modifiedFramework;
    }

    private static List<Pair<String, String>> computeOverrides(String cmdOver, ICliOutput feedback) {
        ArrayList<Pair<String, String>> computedList = new ArrayList<Pair<String, String>>();
        HashSet<String> handledConfigurations = new HashSet<String>();
        for (String configKeyValue : CommonSplitters.CSV.split((CharSequence)cmdOver)) {
            int keyValSplit = configKeyValue.indexOf(58);
            if (keyValSplit == -1) {
                feedback.out().println("ignoring " + configKeyValue + " as it does not contain a ':' to separate key from value.");
                continue;
            }
            if (keyValSplit >= configKeyValue.length() - 1) {
                feedback.out().println("No value was provided after ':' in " + configKeyValue);
                continue;
            }
            String key = configKeyValue.substring(0, keyValSplit);
            String value = configKeyValue.substring(keyValSplit + 1, configKeyValue.length());
            if (handledConfigurations.contains(key)) {
                feedback.out().println("You cannot override the same key twice in a single command: found multiple instances of " + key + " [attempt to set to " + value + " ignored]");
                continue;
            }
            handledConfigurations.add(key);
            computedList.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
        }
        return computedList;
    }

    private IUcSetupSessionStrategy determineApackStrategy(ICliOutput feedback) {
        if (this.extTools.customsDefined()) {
            ISessionApacks sessionApacks = this.extTools.apackManager().loadSessionApacks(this.extTools.customAdapterPacks(feedback), feedback.unifiedLogger());
            return new SltApackLoading(sessionApacks);
        }
        return OriginalSdkBasedApackLoading.instance();
    }

    private IUcContext loadContext(Path genDir, IUcSdkContent sdk, Path realProjFile, boolean sltEnabled, ICliOutput feedback) {
        IUcContext context;
        Path localGenDir;
        Path path = localGenDir = genDir != null ? genDir : realProjFile.getParent();
        if (sdk.parentSdk() == null && RuntimeUtils.isJUnitRunning()) {
            context = this.createLegacyContext(sdk, localGenDir, realProjFile, feedback);
        } else {
            if (sdk.parentSdk() == null) {
                feedback.err().println("This command operation is trying to execute against an slc framework without a valid sdk wrapping it. A valid .properties companion file is required.");
                return null;
            }
            IUcSetupSessionStrategy apackStrategy = this.determineApackStrategy(feedback);
            UcContextSessionConfiguration sessionLoadConfiguration = new UcContextSessionConfiguration(sltEnabled, apackStrategy);
            Result result = new UcContextRequest().setGenerationDirectory(localGenDir).setDataDirectoryOrFile(realProjFile).setSdk(sdk.parentSdk().getId()).setContextSessionConfiguration((IUcContextSessionConfiguration)sessionLoadConfiguration).setLogger(feedback.unifiedLogger()).replaceIfExisting(true).findOrCreate();
            context = !result.isOK() && RuntimeUtils.isJUnitRunning() ? this.createLegacyContext(sdk, localGenDir, realProjFile, feedback) : (IUcContext)result.unwrap(null, issue -> feedback.err().println("Could not create context due to " + issue.message()));
        }
        if (context != null) {
            feedback.registerContext(context);
        }
        return context;
    }

    private IUcContext createLegacyContext(IUcSdkContent sdk, Path localGenDir, Path realProjFile, ICliOutput feedback) {
        assert (RuntimeUtils.isJUnitRunning()) : "Legacy Contexts are only supported in Junit. Avoid this function outside of them";
        feedback.out().println("Creating a legacy context -- note that legacy context creation does not respect session configuration so SLT-aware pieces may have issues (such as warning about missing components in extensions included on the command line). Make your test have a valid .properties for its sdk to avoid this!");
        UcContext context = UcContext.existingContext((IUcSdkContent)sdk, (boolean)false, (Path)localGenDir, (Path)realProjFile, (boolean)false, (ISlcwRegistryMutable)SlcwRegistryManager.primaryRegistry(), (IUcContextSessionConfiguration)IUcContextSessionConfiguration.reasonableDefault(), (IUnifiedLogger)feedback.unifiedLogger());
        ((UcContextManager)IUcContextManager.instance()).putNewContext(localGenDir.toFile(), (IUcContext)context, true);
        return context;
    }

    private static Result<Path, UcParsingException> validateSlcpDir(Path projFileResolved, ICliOutput feedback) {
        List projFiles;
        try {
            Throwable throwable = null;
            Object var4_4 = null;
            try (Stream<Path> stream = Files.walk(projFileResolved, 1, new FileVisitOption[0]);){
                projFiles = stream.filter(p -> IUcBackingStore.SLCP.type().equals(FileUtils.getExtension((String)p.toString().toLowerCase(Locale.ROOT)))).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return Result.err((Object)((Object)new UcParsingException("Failed to load slcp directory " + String.valueOf(projFileResolved))));
        }
        if (projFiles.size() > 1) {
            feedback.err().println("Found multiple slcp files at the slcp directory " + String.valueOf(projFileResolved));
            feedback.err().println("Please specify the exact slcp to generate for.");
            return Result.err((Object)((Object)new UcParsingException("Failed to determine slcp file.")));
        }
        if (projFiles.isEmpty()) {
            feedback.err().println("Found no slcp files at the slcp directory " + String.valueOf(projFileResolved));
            return Result.err((Object)((Object)new UcParsingException("Failed to determine slcp file.")));
        }
        return Result.ok((Object)((Path)projFiles.get(0)));
    }
}

