/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.Result;
import com.silabs.ss.framework.uc.api.project.IUcContextManager;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.context.IUcContext;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssue;
import com.silabs.ss.framework.uc.core.api.meta.exception.UcParsingException;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.ISlcwRegistryMutable;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.ss.framework.uc.core.internal.api.model.slcw.SlcwRegistry;
import com.silabs.ss.framework.uc.core.internal.api.parse.schema.slcw.SlcwWarningsValidator;
import com.silabs.ss.framework.uc.core.internal.project.IUcContextManagerInternal;
import com.silabs.uc.cli.internal.command.exception.WorkspaceRequiredException;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class CliProjectOrWorkspace {
    @CommandLine.Mixin
    CliProject projectExplicit;
    public static final ImmutableList<String> WORKSPACE_OPTIONS = ImmutableList.of((Object)"-w", (Object)"--workspace");
    @CommandLine.Option(names={"-w", "--workspace"}, paramLabel="WORKSPACE_SLCW", description={"Location of the .slcw workspace file for use with this operation.This option can be ommitted if the workspace is referenced via a positional parameter."})
    private String workspaceLocation;
    @CommandLine.Option(names={"-pids", "--projects"}, paramLabel="PROJECT_IDS_IN_WORKSPACE", split=",", splitSynopsisLabel=",", description={"A String list of project ids, delimited by commas, within the workspace that you would like to generate.This option is expected to be only used alongside a provided --w/--workspace."})
    private List<String> projectIds;
    private final ISlcwRegistryMutable cliWorkspaceRegistry = new SlcwRegistry((IUcContextManagerInternal)IUcContextManager.instance());

    public static CliProjectOrWorkspace createDirectly(String metadata, CliWithinWithout withinWithout, boolean isWorkspace, CliExternalTools extTools) {
        CliProjectOrWorkspace newMixin = new CliProjectOrWorkspace();
        newMixin.projectExplicit = CliProject.createDirectly(isWorkspace ? null : metadata, withinWithout, extTools);
        if (isWorkspace) {
            newMixin.workspaceLocation = metadata;
        }
        return newMixin;
    }

    public ISlcwRegistryMutable cliWorkspaceRegistry() {
        return this.cliWorkspaceRegistry;
    }

    public String workspaceLocation() {
        return this.workspaceLocation;
    }

    public List<String> projectIdsInWorkspace() {
        return this.projectIds;
    }

    public String projectLocation() {
        return this.projectExplicit.projectLocation();
    }

    public List<String> withinComponents() {
        return this.projectExplicit.withinComponents();
    }

    public String destination() {
        return this.projectExplicit.destination();
    }

    public boolean isWorkspaceOperation() {
        return this.workspaceLocation != null && !this.workspaceLocation.isEmpty();
    }

    public CliExternalTools extTools() {
        return this.projectExplicit.extTools();
    }

    Optional<ProjectContainer> loadProjectContainerWithLocation(String finalProjectLocation, IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean allowMissingComponents, boolean force) {
        return this.projectExplicit.loadProjectContainerWithLocation(finalProjectLocation, sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, allowMissingComponents, false, force);
    }

    public Result<IUcWorkspace, ? extends UcException> loadWorkspace(IUcSdk sdk, ICliOutput feedback, String workspaceLoc, boolean force) {
        Path slcwFile;
        Result<IUcWorkspace, ? extends UcException> workspaceResult;
        String workspaceLocationToLoad = workspaceLoc;
        if (workspaceLocationToLoad == null) {
            workspaceLocationToLoad = this.workspaceLocation();
        }
        if (!(workspaceResult = this.parseWorkspaceFile(feedback, slcwFile = feedback.resolve(workspaceLocationToLoad), sdk, force)).isOK()) {
            feedback.err().println("The provided workspace file " + workspaceLocationToLoad + " had the following errors:");
            feedback.err().println(((UcException)((Object)workspaceResult.right())).getMessage());
            return workspaceResult;
        }
        List warnings = SlcwWarningsValidator.validateSlcw((IUcWorkspace)((IUcWorkspace)workspaceResult.okValue()));
        if (!warnings.isEmpty()) {
            UcParsingException parseWarnings = this.stringifyForCli(warnings);
            if (force) {
                feedback.err().println("Warnings loading workspace:\n" + parseWarnings.getMessage());
            } else {
                feedback.err().println("Errors loading workspace " + String.valueOf(slcwFile) + ": Refusing to continue. Specify '--force' if these issues should be ignored.\n" + parseWarnings.getMessage());
                return Result.err((Object)((Object)parseWarnings));
            }
        }
        return workspaceResult;
    }

    private Result<IUcWorkspace, ? extends UcException> parseWorkspaceFile(ICliOutput feedback, Path slcwFile, IUcSdk sdk, boolean force) {
        if (!Files.isRegularFile(slcwFile, new LinkOption[0])) {
            return Result.err((Object)((Object)new WorkspaceRequiredException("Workspace file does not exist: " + String.valueOf(slcwFile))));
        }
        Result workspace = null;
        try {
            workspace = this.cliWorkspaceRegistry.findOrParseFromWorkspaceFile(slcwFile, sdk.framework()).transformError(this::stringifyForCli);
        }
        catch (Exception e) {
            return Result.err((Object)((Object)new UcException("Failed to load the workspace file. " + e.getMessage(), (Throwable)e, -5)));
        }
        return workspace;
    }

    private UcParsingException stringifyForCli(Collection<ParseIssue> issues) {
        String msg = issues.stream().map(issue -> " - " + issue.message()).collect(Collectors.joining("\n"));
        return new UcParsingException(msg, -5);
    }

    public Optional<IUcProject> getWorkspaceProjectContext(IUcWorkspace loadedWorkspace, IUcSdk sdk, IUcWorkspaceIncludedProject workspaceProject, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean failOnWarnings, boolean force) {
        Optional container = this.loadWorkspaceProjectResults(loadedWorkspace, sdk, workspaceProject, feedback, sltFeatures, failOnWarnings, force).mapError(e -> feedback.unifiedLogger().userError("Failed to load project: " + String.valueOf(e), null));
        return container.map(ProjectContainer::project);
    }

    public Result<ProjectContainer, ? extends UcException> loadWorkspaceProjectResults(IUcWorkspace loadedWorkspace, IUcSdk sdk, IUcWorkspaceIncludedProject workspaceProject, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean failOnWarnings, boolean force) {
        Result contextResult = this.cliWorkspaceRegistry.request(loadedWorkspace, workspaceProject.id(), sdk).setLogger(feedback.unifiedLogger()).replaceIfExisting(true).findOrCreate();
        if (!contextResult.isOK()) {
            return contextResult.mapResult(ProjectContainer.class::cast).transformError(e -> new UcException("Failed to load context: " + String.valueOf(e), -4));
        }
        return this.projectExplicit.loadProjectFromContext((IUcContext)contextResult.okValue(), sltFeatures, failOnWarnings, false, force, feedback);
    }
}

