/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.silabs.java.utils.Result;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.uc.cli.internal.command.exception.WorkspaceRequiredException;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliProjectOrWorkspace;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import picocli.CommandLine;

public class CliProjectOrWorkspaceImplicit {
    private static final String WORKSPACE_FILE_EXTENSION = ".slcw";
    private static final String PROJECT_FILE_EXTENSION = ".slcp";
    @CommandLine.Mixin
    CliProjectOrWorkspace projectOrWorkspaceExplicit;
    @CommandLine.Parameters
    List<String> optionalParams = new ArrayList<String>();
    private String finalWorkspaceLocation;
    private String finalProjectLocation;

    public static CliProjectOrWorkspaceImplicit createDirectly(String metadata, CliWithinWithout withinWithout, boolean isWorkspace, CliExternalTools extTools) {
        CliProjectOrWorkspaceImplicit newMixin = new CliProjectOrWorkspaceImplicit();
        newMixin.projectOrWorkspaceExplicit = CliProjectOrWorkspace.createDirectly(metadata, withinWithout, isWorkspace, extTools);
        return newMixin;
    }

    public String workspaceLocation() {
        return this.finalWorkspaceLocation;
    }

    public List<String> projectIdsInWorkspace() {
        return this.projectOrWorkspaceExplicit.projectIdsInWorkspace();
    }

    public String projectLocation() {
        return this.finalProjectLocation;
    }

    public String destination() {
        return this.projectOrWorkspaceExplicit.destination();
    }

    public CliExternalTools extTools() {
        return this.projectOrWorkspaceExplicit.extTools();
    }

    public boolean isWorkspaceOperation() {
        return this.projectOrWorkspaceExplicit.isWorkspaceOperation() || this.optionalParamIsWorkspace();
    }

    private boolean optionalParamIsWorkspace() {
        String optionalParam = this.optionalParamOrNull();
        if (optionalParam == null) {
            return false;
        }
        return optionalParam.endsWith(WORKSPACE_FILE_EXTENSION);
    }

    private boolean optionalParamIsProjectFile() {
        String optionalParam = this.optionalParamOrNull();
        if (optionalParam == null) {
            return false;
        }
        return optionalParam.endsWith(PROJECT_FILE_EXTENSION);
    }

    private String optionalParamOrNull() {
        return !this.optionalParams.isEmpty() ? this.optionalParams.get(0) : null;
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDestination, required, false, force);
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, true, force);
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean allowMissingComponents, boolean force) {
        String projectLocation = this.projectOrWorkspaceExplicit.projectLocation();
        if (projectLocation != null && !this.optionalParams.isEmpty() && this.optionalParamIsProjectFile()) {
            feedback.out().println("Do not supply a project location as both a positional parameter and an option. Using " + projectLocation + " for this run.");
        }
        this.finalProjectLocation = projectLocation != null ? projectLocation : (this.optionalParamIsProjectFile() ? this.optionalParamOrNull() : null);
        return this.projectOrWorkspaceExplicit.loadProjectContainerWithLocation(this.finalProjectLocation, sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, allowMissingComponents, force);
    }

    public Result<IUcWorkspace, ? extends UcException> loadWorkspace(IUcSdk sdk, ICliOutput feedback, boolean force) {
        String workspaceLocation = this.projectOrWorkspaceExplicit.workspaceLocation();
        if (workspaceLocation == null && this.optionalParams.isEmpty()) {
            throw new WorkspaceRequiredException();
        }
        if (workspaceLocation != null && !this.optionalParams.isEmpty() && this.optionalParamIsWorkspace()) {
            feedback.out().println("Do not supply a workspace location as both a positional parameter and an option. Using " + workspaceLocation + " for this run.");
        }
        this.finalWorkspaceLocation = workspaceLocation != null ? workspaceLocation : (this.optionalParamIsWorkspace() ? this.optionalParamOrNull() : null);
        return this.projectOrWorkspaceExplicit.loadWorkspace(sdk, feedback, this.finalWorkspaceLocation, force);
    }

    public Optional<IUcProject> loadWorkspaceProject(IUcWorkspace workspace, IUcSdk sdk, IUcWorkspaceIncludedProject workspaceProject, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean failOnWarnings, boolean force) {
        return this.projectOrWorkspaceExplicit.getWorkspaceProjectContext(workspace, sdk, workspaceProject, feedback, sltFeatures, failOnWarnings, force);
    }

    public Result<ProjectContainer, ? extends UcException> loadWorkspaceProjectResults(IUcWorkspace loadedWorkspace, IUcSdk sdk, IUcWorkspaceIncludedProject workspaceProject, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean failOnWarnings, boolean force) {
        return this.projectOrWorkspaceExplicit.loadWorkspaceProjectResults(loadedWorkspace, sdk, workspaceProject, feedback, sltFeatures, failOnWarnings, force);
    }
}

