/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.creator;

import com.silabs.uc.cli.internal.daemon.creator.ISlcDaemonCreator;
import com.silabs.uc.cli.internal.daemon.shared.DaemonVersionInfo;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public final class OSGiDaemonVersionInfo
extends DaemonVersionInfo {
    public static DaemonVersionInfo create(ISlcDaemonCreator daemonCreator) {
        Map<String, Version> versionMap = OSGiDaemonVersionInfo.computeSilabsMaxVersions(daemonCreator.bundleContext());
        return new OSGiDaemonVersionInfo(OSGiDaemonVersionInfo.convertMap(versionMap));
    }

    private OSGiDaemonVersionInfo(Map<String, String> versionInfo) {
        super(versionInfo);
    }

    private static Map<String, Version> computeSilabsMaxVersions(BundleContext context) {
        HashMap<String, Version> pluginIdToMaxVersion = new HashMap<String, Version>();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String symName = bundle.getSymbolicName();
            if (symName.startsWith("com.silabs")) {
                if (!pluginIdToMaxVersion.containsKey(symName)) {
                    pluginIdToMaxVersion.put(bundle.getSymbolicName(), bundle.getVersion());
                } else {
                    Version putVersion = (Version)pluginIdToMaxVersion.get(symName);
                    Version ourVersion = bundle.getVersion();
                    if (ourVersion.compareTo(putVersion) > 0) {
                        pluginIdToMaxVersion.put(symName, ourVersion);
                    }
                }
            }
            ++n2;
        }
        return pluginIdToMaxVersion;
    }
}

