/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.silabs.java.utils.StreamUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.comp.Overrider;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.model.ucmetadata.IUcMetaBoard;
import com.silabs.ss.framework.uc.core.api.model.ucmetadata.IUcMetaDevice;
import com.silabs.ss.framework.uc.core.api.model.ucmetadata.IUcMetaKit;
import com.silabs.ss.framework.uc.core.api.model.ucmetadata.IUcMetaPintool;
import com.silabs.ss.framework.uc.core.api.model.ucmetadata.IUcMetaToolchain;
import com.silabs.ss.framework.uc.core.api.model.ucmetadata.IUcMetadata;
import com.silabs.ss.framework.uc.core.internal.api.parse.SlccKey;
import com.silabs.uc.cli.internal.filter.SearchableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class FilterEngine {
    public static final String GRAMMER_EQUALS = "=";
    public static final String GRAMMER_CONTAINS = "~";
    public static final String GRAMMER_NOT = "!";
    private static final CompatibleTrue TRUE_NO_META = new CompatibleTrue(Collections.emptyList());
    private static final CompatibleFalse FALSE_NO_META = new CompatibleFalse(Collections.emptyList());

    public static boolean isAnd(String op) {
        return op.equalsIgnoreCase("and");
    }

    public static boolean isOr(String op) {
        return op.equalsIgnoreCase("or");
    }

    public static Object handleLogical(SearchableComponent component, String op, Object o1, Object o2, IUnifiedLogger logger) {
        Compatible ret = FilterEngine.compare(component, op, o1, o2, logger);
        return ret;
    }

    private static boolean equalsOrContains(String op) {
        return GRAMMER_EQUALS.equals(op) || GRAMMER_CONTAINS.equals(op);
    }

    public static Compatible compare(SearchableComponent component, String op, Object o1, Object o2, IUnifiedLogger logger) {
        if (op == null) {
            throw new IllegalArgumentException("Input operation was null!");
        }
        Compatible doCompare = FALSE_NO_META;
        if (FilterEngine.equalsOrContains(op)) {
            String key = o1.toString();
            String value = o2.toString().replace("'", "").replace("'", "");
            SlccKey searchThis = SlccKey.find((String)key);
            if (searchThis.isSearchable()) {
                if (value.equals("*")) {
                    List<String> searchList = searchThis.searchable((Object)component.component()).collect(Collectors.toList());
                    doCompare = Compatible.of(!searchList.isEmpty(), searchList);
                } else {
                    boolean contains = GRAMMER_CONTAINS.equals(op);
                    Stream<String> searchParts = searchThis.searchable((Object)component.component());
                    boolean caseSensitive = searchThis.isCaseSensitive();
                    searchParts = caseSensitive ? searchParts : searchParts.map(s -> s.toLowerCase(Locale.ROOT));
                    List<String> answerMeta = (contains ? searchParts.filter(k -> k.contains(caseSensitive ? value : value.toLowerCase(Locale.ROOT))) : searchParts.filter(k -> k.equals(caseSensitive ? value : value.toLowerCase(Locale.ROOT)))).collect(Collectors.toList());
                    doCompare = Compatible.of(!answerMeta.isEmpty(), answerMeta);
                }
            } else if (searchThis == SlccKey.UNKNOWN) {
                doCompare = FilterEngine.checkExtraKeys(component, GRAMMER_CONTAINS.equals(op), key, value, logger);
                if (doCompare == null) {
                    FilterEngine.cancelParse("Not a valid meta nor supplemental key: " + key, logger);
                }
            } else if ("metadata".equals(key)) {
                FilterEngine.cancelParse("metadata, on its own, is not a searchable key. You must use specific variants, such as metadata:device, metadata:board, metadata:toolchain, metadata:kit, metadata:pin_tool. Refer to documentation for more information.", logger);
            } else {
                FilterEngine.cancelParse("Meta key '" + key + "' is valid, but not searchable", logger);
            }
        } else if (FilterEngine.isAnd(op)) {
            doCompare = FilterEngine.doLogicOrAnd(true, o1, o2, logger);
        } else if (FilterEngine.isOr(op)) {
            doCompare = FilterEngine.doLogicOrAnd(false, o1, o2, logger);
        } else assert (false) : "Operation " + op + " should not be handled by this part of the engine!";
        return doCompare;
    }

    private static Compatible checkExtraKeys(SearchableComponent c, boolean contains, String key, String value, IUnifiedLogger logger) {
        block41: {
            String lowerKey;
            boolean matchAll = "*".equals(value);
            switch (lowerKey = key.toLowerCase(Locale.ROOT)) {
                case "overrider": {
                    ArrayList<String> metaSearch = new ArrayList<String>();
                    for (Overrider over : StreamUtils.iterableOf(c.component().overriderConfigFiles().stream().map(IConditional::data))) {
                        if (FilterEngine.matches(over.componentId(), value, matchAll, contains)) {
                            metaSearch.add("for component " + over.componentId() + " from " + c.id());
                        }
                        if (FilterEngine.matches(over.instance().orElse(null), value, matchAll, contains)) {
                            metaSearch.add("for instance name " + (String)over.instance().orElse(null) + " from " + c.id());
                        }
                        if (!FilterEngine.matches(over.overrideId(), value, matchAll, contains)) continue;
                        metaSearch.add("for override id " + over.overrideId() + " from " + c.id());
                    }
                    return Compatible.of(!metaSearch.isEmpty(), metaSearch);
                }
                case "extension_id": {
                    if (contains) {
                        FilterEngine.cancelParse("contains not supported for extension_id key.", logger);
                    }
                    if ("_".equals(value)) {
                        return Compatible.of(c.extId().isBlank(), (List<String>)ImmutableList.of());
                    }
                    return Compatible.of(c.extId().equals(value), (List<String>)ImmutableList.of());
                }
            }
            if (!lowerKey.startsWith("metadata:")) break block41;
            if (c.component().metadata().isEmpty()) {
                return Compatible.of(false);
            }
            IUcMetadata genericMetadata = (IUcMetadata)c.component().metadata().get();
            Object searchableString = "";
            switch (lowerKey) {
                case "metadata:device": {
                    if (genericMetadata.device().isEmpty()) {
                        return Compatible.of(false);
                    }
                    IUcMetaDevice device = (IUcMetaDevice)genericMetadata.device().get();
                    searchableString = FilterEngine.createSearchableString("opn", device.opn());
                    break;
                }
                case "metadata:board": {
                    if (genericMetadata.board().isEmpty()) {
                        return Compatible.of(false);
                    }
                    IUcMetaBoard board = (IUcMetaBoard)genericMetadata.board().get();
                    searchableString = FilterEngine.createSearchableString("pn", board.pn(), "variant", board.variant(), "revision", board.revision());
                    break;
                }
                case "metadata:toolchain": {
                    if (genericMetadata.toolchain().isEmpty()) {
                        return Compatible.of(false);
                    }
                    IUcMetaToolchain toolchain = (IUcMetaToolchain)genericMetadata.toolchain().get();
                    searchableString = FilterEngine.createSearchableString("id", toolchain.id().orElse("none"), "variant", toolchain.variant().orElse("none"));
                    break;
                }
                case "metadata:pin_tool": {
                    if (genericMetadata.pintool().isEmpty()) {
                        return Compatible.of(false);
                    }
                    IUcMetaPintool pintool = (IUcMetaPintool)genericMetadata.pintool().get();
                    searchableString = "peripheral:" + pintool.peripheral().stream().collect(Collectors.joining(" "));
                    break;
                }
                case "metadata:kit": {
                    if (genericMetadata.kit().isEmpty()) {
                        return Compatible.of(false);
                    }
                    IUcMetaKit kit = (IUcMetaKit)genericMetadata.kit().get();
                    searchableString = FilterEngine.createSearchableString("opn", kit.opn(), "pn", kit.pn(), "variant", kit.variant(), "revision", kit.revision());
                    break;
                }
                default: {
                    FilterEngine.cancelParse("The metadata specifier " + lowerKey + " is not valid.", logger);
                    return null;
                }
            }
            return Compatible.of(FilterEngine.matches((String)searchableString, value, matchAll, contains));
        }
        return null;
    }

    private static String createSearchableString(String ... pieces) {
        assert (pieces.length % 2 == 0);
        StringBuilder builder = new StringBuilder();
        int separatorCutoff = pieces.length - 2;
        int i = 0;
        while (i < pieces.length) {
            builder.append(pieces[i] + ":" + pieces[i + 1]);
            if (separatorCutoff != i) {
                builder.append(" ");
            }
            i += 2;
        }
        return builder.toString();
    }

    private static void cancelParse(String msg, IUnifiedLogger logger) throws ParseCancellationException {
        logger.userWarning(msg, null);
        throw new ParseCancellationException(msg);
    }

    private static boolean matches(String data, String value, boolean matchAll, boolean contains) {
        if (matchAll) {
            return true;
        }
        if (TextUtils.isEmpty((String)data)) {
            return false;
        }
        return contains ? data.contains(value) : data.equals(value);
    }

    public static Compatible handleExpression(SearchableComponent component, String op, Object o1, Object o2, IUnifiedLogger logger) {
        return FilterEngine.compare(component, op, o1, o2, logger);
    }

    public static Compatible handleNot(SearchableComponent component, Object primaryValue, IUnifiedLogger logger) {
        if (primaryValue instanceof Compatible) {
            return ((Compatible)primaryValue).not();
        }
        if (primaryValue instanceof Boolean) {
            return Compatible.of((Boolean)primaryValue);
        }
        return Compatible.of(Boolean.valueOf(primaryValue.toString()));
    }

    public static Compatible doLogicOrAnd(boolean doAnd, Object o1, Object o2, IUnifiedLogger logger) {
        if (o1 instanceof Compatible && o2 instanceof Compatible) {
            return ((Compatible)o1).applyLogicalOp((Compatible)o2, !doAnd);
        }
        return Compatible.of(Boolean.TRUE.equals(o1) && Boolean.TRUE.equals(o2));
    }

    public static interface Compatible {
        public Compatible applyLogicalOp(Compatible var1, boolean var2);

        public Compatible not();

        public boolean isTrue();

        public List<String> metadata();

        default public String metadataAsString() {
            return this.metadata().stream().collect(Collectors.joining(" "));
        }

        public Compatible applyMetadata(List<String> var1);

        public static Compatible of(boolean bool) {
            return bool ? TRUE_NO_META : FALSE_NO_META;
        }

        public static Compatible of(boolean bool, List<String> meta) {
            return bool ? new CompatibleTrue(meta) : new CompatibleFalse(meta);
        }
    }

    public static class CompatibleFalse
    extends CompatibleSkeleton {
        public CompatibleFalse(List<String> metadata) {
            super(metadata);
        }

        @Override
        public Compatible applyLogicalOp(Compatible compare, boolean shouldOr) {
            return shouldOr ? compare.applyMetadata((List<String>)ImmutableList.copyOf((Iterable)Iterables.concat(compare.metadata(), this.metadata()))) : this.applyMetadata((List)ImmutableList.copyOf((Iterable)Iterables.concat(this.metadata(), compare.metadata())));
        }

        @Override
        public Compatible not() {
            List<String> meta = this.metadata();
            if (meta.isEmpty()) {
                return TRUE_NO_META;
            }
            return new CompatibleTrue(meta);
        }

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public CompatibleFalse applyMetadata(List<String> meta) {
            return new CompatibleFalse(meta);
        }
    }

    public static abstract class CompatibleSkeleton
    implements Compatible {
        private final List<String> metadata;

        public CompatibleSkeleton(List<String> meta) {
            this.metadata = meta;
        }

        @Override
        public List<String> metadata() {
            return this.metadata;
        }
    }

    public static class CompatibleTrue
    extends CompatibleSkeleton {
        public CompatibleTrue(List<String> metadata) {
            super(metadata);
        }

        @Override
        public Compatible applyLogicalOp(Compatible compare, boolean shouldOr) {
            return shouldOr ? this.applyMetadata((List)ImmutableList.copyOf((Iterable)Iterables.concat(this.metadata(), compare.metadata()))) : compare.applyMetadata((List<String>)ImmutableList.copyOf((Iterable)Iterables.concat(compare.metadata(), this.metadata())));
        }

        @Override
        public Compatible not() {
            List<String> meta = this.metadata();
            if (meta.isEmpty()) {
                return FALSE_NO_META;
            }
            return new CompatibleFalse(this.metadata());
        }

        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public CompatibleTrue applyMetadata(List<String> meta) {
            return new CompatibleTrue(meta);
        }
    }
}

