/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.filter;

import com.google.common.collect.ImmutableMap;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcFrameworkCommon;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class SearchableFramework {
    private final ImmutableMap<String, IUcFrameworkCommon> idToFramework;
    private final Predicate<IUcComponent> projectFilter;

    private SearchableFramework(IUcFramework mainFramework, IUcProject project) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"", (Object)mainFramework);
        for (Map.Entry idExtPair : mainFramework.sdkExtensions().entrySet()) {
            String extId = ((IUcSdkExtensionId)idExtPair.getKey()).toString();
            builder.put((Object)extId, (Object)((IUcFrameworkCommon)idExtPair.getValue()));
        }
        this.idToFramework = builder.build();
        this.projectFilter = project != null ? comp -> project.hasComponent(comp.id()) : comp -> true;
    }

    public Stream<IUcComponent> componentsForFilter(String extensionId) {
        String string = extensionId = extensionId != null ? extensionId : "";
        if ("*".equals(extensionId)) {
            return this.idToFramework.values().stream().flatMap(IUcComponentContainer::allComponents);
        }
        return ((IUcFrameworkCommon)this.idToFramework.get((Object)extensionId)).allComponents().filter(this.projectFilter);
    }
}

