/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.UcComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.meta.IMetaSource;
import com.silabs.ss.framework.uc.core.api.meta.UcFactory;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.rule.ApiRule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class UcExampleDefinition {
    private static final String PACKAGE_PATH_MAPPING = "packagePathMapping";
    private static final String PACKAGE_PATH = "path";
    private static final String PACKAGE_PACKAGE = "package";
    private static final String BOARD_COMPAT = "boardCompat";
    private static final String PART_COMPAT = "partCompat";
    private static final String REQUIRED_PROVIDES = "requiredProvides";
    private static final String RESTRICT_PROVIDES = "restrictProvides";
    private static final String IGNORE_REVISIONS = "ignoreRevisions";
    private static final String VIRTUAL_BOARD_COMPS = "virtualBoardComponents";
    private static final String WRAPPED_COMPONENT = "component";
    public static final String VIRTUAL_BOARDS_EXTENSION = "virtual_boards";
    private static final String DEFAULT_PKG_MAPPING = "examples_gendef.yml";
    private final Path pkgFile;
    private final List<String> warnings = new ArrayList<String>();
    private Map<String, File> pkgMap = new HashMap<String, File>();
    private Map<String, Pair<String, String>> compatMap = new HashMap<String, Pair<String, String>>();
    private Map<String, Set<String>> requiredProvides = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> restrictProvides = new HashMap<String, Set<String>>();
    private Map<String, Boolean> ignoreRevisions = new HashMap<String, Boolean>();
    private Map<String, IUcComponent> virtualBoards = new HashMap<String, IUcComponent>();

    public static UcExampleDefinition loadDefault(IUcSdkContent sdk) throws IOException {
        return UcExampleDefinition.load(sdk, sdk.framework().directory().toPath().resolve(DEFAULT_PKG_MAPPING));
    }

    public static UcExampleDefinition load(IUcSdkContent sdk, Path pkgFile) throws IOException {
        if (!Files.isReadable(pkgFile)) {
            throw new IllegalArgumentException("No package mapping file found or does not exist at " + pkgFile.toString() + " Please define a path to the file using the 'pkgmap' argument.");
        }
        return new UcExampleDefinition(sdk, pkgFile);
    }

    private UcExampleDefinition(IUcSdkContent sdk, Path pkgFile) throws IOException {
        this.pkgFile = pkgFile;
        this.loadGenDef(sdk);
    }

    private void loadGenDef(IUcSdkContent sdk) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = Files.newInputStream(this.pkgFile, new OpenOption[0]);){
            Map data = UcFactory.yamlReader().readMap(is, this.pkgFile.toString());
            Boolean globalIgnoreRevisions = this.getIgnoreRevisions(data, Boolean.FALSE);
            Collection<?> pathMapping = this.doLoadList(data, PACKAGE_PATH_MAPPING);
            for (Object key : pathMapping) {
                Collection<?> restrictList;
                Map pkgPath = (Map)key;
                String pkg = this.doLoadString(pkgPath, PACKAGE_PACKAGE, true).toLowerCase(Locale.ROOT);
                String propPathStr = this.doLoadString(pkgPath, PACKAGE_PATH, true);
                Path propPath = FileUtils.resolve((Path)this.pkgFile.getParent(), (String)propPathStr);
                if (!Files.isWritable(propPath)) {
                    Path propPkgFile = propPath;
                    propPath = FileUtils.resolve((Path)sdk.framework().directory().toPath(), (String)propPathStr);
                    if (!Files.isWritable(propPath)) {
                        this.warnings.add("Warning: Cannot write to " + propPkgFile.toString() + " or the fallback location " + propPath.toString() + ". Metadata for " + pkg + " will not be generated.");
                    }
                }
                if (this.pkgMap.containsKey(pkg)) {
                    this.warnings.add("Warning: Duplicate package files for " + pkg + ". No metadata willbe generated for these packages.");
                }
                this.pkgMap.put(pkg, propPath.toFile());
                String boardCompat = this.doLoadString(pkgPath, BOARD_COMPAT, false);
                String partCompat = this.doLoadString(pkgPath, PART_COMPAT, false);
                this.compatMap.put(pkg, (Pair<String, String>)new Pair((Object)boardCompat, (Object)partCompat));
                this.ignoreRevisions.put(pkg, this.getIgnoreRevisions(pkgPath, globalIgnoreRevisions));
                Collection<?> reqList = this.doLoadList(pkgPath, REQUIRED_PROVIDES);
                if (!reqList.isEmpty()) {
                    this.requiredProvides.put(pkg, reqList.stream().map(String::valueOf).collect(Collectors.toSet()));
                }
                if ((restrictList = this.doLoadList(pkgPath, RESTRICT_PROVIDES)).isEmpty()) continue;
                this.restrictProvides.put(pkg, restrictList.stream().map(String::valueOf).collect(Collectors.toSet()));
            }
            Collection<?> virtualBoardComps = this.doLoadList(data, VIRTUAL_BOARD_COMPS);
            for (Object key : virtualBoardComps) {
                Map virtualBoardCompData = (Map)key;
                String virtualBoardCompId = this.doLoadString(virtualBoardCompData, WRAPPED_COMPONENT, true).toLowerCase(Locale.ROOT);
                String boardId = "virtual_board_" + virtualBoardCompId;
                this.virtualBoards.put(boardId, (IUcComponent)UcComponent.builder((IMetaSource)IMetaSource.NO_SOURCE).setId(boardId).setQuality(ComponentQuality.INTERNAL).addDependency(ApiRule.required((IConditional)IConditional.unconditional((Object)ApiId.make((String)virtualBoardCompId)))).addTag("hardware:fake_hardware").addTag("board:pn:" + boardId).build());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Collection<?> doLoadList(Map<?, ?> data, String key) {
        Object dataObj = data.get(key);
        if (dataObj == null) {
            return List.of();
        }
        if (dataObj instanceof Collection) {
            return (Collection)dataObj;
        }
        throw new IllegalArgumentException("Unknown data type for '" + key + "'. This should be a list if present.");
    }

    private String doLoadString(Map<?, ?> data, String key, boolean required) {
        Object dataObj = data.get(key);
        if (!required && dataObj == null) {
            return "";
        }
        if (dataObj instanceof String) {
            return (String)dataObj;
        }
        StringBuilder sb = new StringBuilder("Unknown data type for '").append(key).append("'. ");
        if (required) {
            sb.append("This key is required to be present as a String");
        } else {
            sb.append("This key must be a String if present");
        }
        throw new IllegalArgumentException(sb.toString());
    }

    private Boolean getIgnoreRevisions(Map<?, ?> data, Boolean defaultVal) {
        return data.get(IGNORE_REVISIONS) == null ? defaultVal : data.get(IGNORE_REVISIONS);
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public File propFile(String pkg) {
        return this.getPkgValue(pkg, this.pkgMap).orElse(null);
    }

    public String boardCompat(String pkg) {
        return this.getPkgValue(pkg, this.compatMap).map(Pair::first).filter(TextUtils::hasContent).orElse(".*");
    }

    public String partCompat(String pkg) {
        return this.getPkgValue(pkg, this.compatMap).map(Pair::second).filter(TextUtils::hasContent).orElse("mcu.arm.*");
    }

    public Set<String> requiredProvides(String pkg) {
        return this.getPkgValue(pkg, this.requiredProvides).orElse(Collections.emptySet());
    }

    public Set<String> restrictProvides(String pkg) {
        return this.getPkgValue(pkg, this.restrictProvides).orElse(Collections.emptySet());
    }

    public boolean ignoreRevisions(String pkg) {
        return this.getPkgValue(pkg, this.ignoreRevisions).orElse(Boolean.FALSE);
    }

    public Collection<IUcComponent> getVirtualBoards() {
        return this.virtualBoards.values();
    }

    private <T> Optional<T> getPkgValue(String pkg, Map<String, T> map) {
        return Optional.ofNullable(pkg).map(s -> s.toLowerCase(Locale.ROOT)).map(map::get);
    }
}

