/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.silabs.java.utils.Result;
import com.silabs.ss.framework.project.api.templates.solution.SolutionTemplateProperties;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssue;
import com.silabs.ss.framework.uc.core.api.meta.SourceFile;
import com.silabs.ss.framework.uc.core.api.meta.exception.UcParsingException;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.ss.framework.uc.core.internal.model.slcw.UcWorkspacesUtil;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.uc.cli.internal.model.IUcExampleResult;
import com.silabs.uc.cli.internal.model.UcExampleResults;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class UcExampleWorkspaceResult
implements IUcExampleResult {
    public static final String ERROR_STR = "Workspace loading failures";
    private static final String INVALID_COMPAT = "-ALL";
    private final UcExampleResults parent;
    private final File slcwFile;
    private final IUcWorkspace workspace;
    private final List<ParseIssue> errors;
    private List<Path> primaryProjects;
    private IUcExampleResult primaryProject;
    private static final IUcExampleResult emptyResult = new EmptyExampleResult();

    public static UcExampleWorkspaceResult create(UcExampleResults parent, File slcwFile) {
        Result result;
        try {
            result = UcWorkspacesUtil.unconnectedWorkspace((IUcFramework)parent.framework(), (Path)slcwFile.toPath());
        }
        catch (UcParsingException | IOException e) {
            result = Result.err(List.of(new ParseIssue(slcwFile.toPath(), e.getMessage(), e, null, 0)));
        }
        return new UcExampleWorkspaceResult(parent, slcwFile, (Result<IUcWorkspace, List<ParseIssue>>)result);
    }

    private UcExampleWorkspaceResult(UcExampleResults parent, File slcwFile, Result<IUcWorkspace, List<ParseIssue>> result) {
        this.parent = parent;
        this.slcwFile = slcwFile;
        this.workspace = result.isOK() ? (IUcWorkspace)result.okValue() : null;
        this.errors = result.isOK() ? Collections.emptyList() : (List)result.error();
    }

    @Override
    public boolean isValid() {
        return this.workspace != null && this.project().isValid();
    }

    @Override
    public String title() {
        return "Workspace";
    }

    @Override
    public String name() {
        return this.isValid() ? this.workspace.name() : "";
    }

    @Override
    public File file() {
        return this.slcwFile;
    }

    @Override
    public String packaged() {
        return this.isValid() ? this.project().packaged() : ERROR_STR;
    }

    @Override
    public ComponentQuality quality() {
        if (!this.isValid()) {
            return ComponentQuality.UNKNOWN;
        }
        if (this.workspace.quality() != null) {
            return this.workspace.quality();
        }
        return this.project().quality();
    }

    @Override
    public String description() {
        if (!this.isValid()) {
            return "";
        }
        if (this.workspace.quality() != null) {
            return this.workspace.description();
        }
        return this.project().description();
    }

    @Override
    public String category() {
        return this.isValid() ? this.project().category() : "";
    }

    @Override
    public List<SourceFile> readmeFiles() {
        return this.isValid() ? this.project().readmeFiles() : List.of();
    }

    @Override
    public String projectFilters() {
        return this.isValid() ? this.project().projectFilters() : "";
    }

    @Override
    public String partCompat() {
        return this.isValid() ? this.project().partCompat() : INVALID_COMPAT;
    }

    @Override
    public String boardCompat() {
        return this.isValid() ? this.project().boardCompat() : INVALID_COMPAT;
    }

    @Override
    public String ideCompatibility() {
        return this.isValid() ? this.project().ideCompatibility() : INVALID_COMPAT;
    }

    @Override
    public String toolchainCompat() {
        return this.isValid() ? this.project().toolchainCompat() : INVALID_COMPAT;
    }

    @Override
    public List<ParseIssue> warnings() {
        return List.of();
    }

    @Override
    public List<ParseIssue> errors() {
        return this.errors;
    }

    @Override
    public MDescriptor createTemplate(Path templFile) {
        if (!this.isValid()) {
            return null;
        }
        MDescriptor mdesc = this.parent.createTemplate(templFile, this);
        mdesc.getProperties().put((Object)"namespace", (Object)"template.solution.uc");
        List projIds = this.projects().stream().map(this.parent::calculateProjectId).collect(Collectors.toList());
        mdesc.getProperties().put((Object)"solutionProjects", (Object)SolutionTemplateProperties.SOLUTION_PROJECTS.type().stringize(projIds));
        mdesc.setLabel(this.workspace.label());
        mdesc.setName(this.workspace.name());
        return mdesc;
    }

    private IUcExampleResult project() {
        IUcExampleResult lcl_primaryProject;
        if (this.primaryProject != null) {
            return this.primaryProject;
        }
        List<Path> projects = this.projects();
        if (projects.isEmpty()) {
            return emptyResult;
        }
        this.primaryProject = lcl_primaryProject = projects.stream().map(arg_0 -> this.parent.exampleMap().get(arg_0)).filter(Objects::nonNull).findFirst().orElse(emptyResult);
        return lcl_primaryProject;
    }

    private List<Path> projects() {
        if (this.primaryProjects != null) {
            return this.primaryProjects;
        }
        if (this.workspace == null) {
            return List.of();
        }
        List<Path> lcl_primaryProjects = this.workspace.projects().stream().map(IUcWorkspaceIncludedProject::projectFile).filter(Objects::nonNull).map(Path::normalize).collect(Collectors.toList());
        this.primaryProjects = lcl_primaryProjects;
        return lcl_primaryProjects;
    }

    private static class EmptyExampleResult
    implements IUcExampleResult {
        private EmptyExampleResult() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public String title() {
            return "";
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public File file() {
            return new File("");
        }

        @Override
        public MDescriptor createTemplate(Path templFile) {
            return null;
        }

        @Override
        public List<ParseIssue> warnings() {
            return List.of();
        }

        @Override
        public List<ParseIssue> errors() {
            return List.of();
        }

        @Override
        public String packaged() {
            return "";
        }

        @Override
        public ComponentQuality quality() {
            return ComponentQuality.UNKNOWN;
        }

        @Override
        public String description() {
            return "";
        }

        @Override
        public String category() {
            return "";
        }

        @Override
        public List<SourceFile> readmeFiles() {
            return List.of();
        }

        @Override
        public String projectFilters() {
            return "";
        }

        @Override
        public String partCompat() {
            return "";
        }

        @Override
        public String boardCompat() {
            return "";
        }

        @Override
        public String ideCompatibility() {
            return "";
        }

        @Override
        public String toolchainCompat() {
            return "";
        }
    }
}

