/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.silabs.java.utils.ListenerList;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.INewProjectDescriptor;
import com.silabs.ss.framework.project.api.core.INewProjectDescriptorListener;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.ProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyAccessListener;

public class NewProjectDescriptor
extends ProjectDescriptor
implements INewProjectDescriptor {
    private ITemplate template;
    protected ListenerList<INewProjectDescriptorListener> listeners = new ListenerList();
    protected IPropertyAccessListener updateNotifier = new IPropertyAccessListener(){

        public void valueChanged(IPropertyAccessListener.ValueChangedEvent event) {
            NewProjectDescriptor.this.fireEvent(new INewProjectDescriptorListener.NewProjectDescriptorEvent(INewProjectDescriptorListener.NewProjectDescriptorEvent.NewProjectDescriptorEventType.PROPERTY, event, null, null));
        }
    };

    public NewProjectDescriptor(String projectName, MDescriptor desc) {
        super(projectName, desc);
    }

    public NewProjectDescriptor(String projectName) {
        super(projectName);
    }

    @Override
    public NewProjectDescriptor copy() {
        NewProjectDescriptor newProj = (NewProjectDescriptor)super.copy();
        newProj.template = this.template;
        this.listeners.forEach(newProj::removeListener);
        return newProj;
    }

    @Override
    public void setTemplate(ITemplate templ) {
        String oldTemplateId = this.template == null ? null : this.template.getId();
        String newTemplateId = templ == null ? null : templ.getId();
        this.template = templ;
        this.fireEvent(new INewProjectDescriptorListener.NewProjectDescriptorEvent(INewProjectDescriptorListener.NewProjectDescriptorEvent.NewProjectDescriptorEventType.TEMPLATE, null, oldTemplateId, newTemplateId));
    }

    @Override
    public ITemplate getTemplate() {
        return this.template;
    }

    @Override
    public void addListener(INewProjectDescriptorListener listener) {
        if (this.listeners.isEmpty()) {
            this.getPropertyAccess().addListener(this.updateNotifier);
        }
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(INewProjectDescriptorListener listener) {
        this.listeners.remove((Object)listener);
        if (this.listeners.isEmpty()) {
            this.getPropertyAccess().removeListener(this.updateNotifier);
        }
    }

    @Override
    public void fireEvent(INewProjectDescriptorListener.NewProjectDescriptorEvent event) {
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INewProjectDescriptorListener)listener).valueChanged(event);
            ++n2;
        }
    }

    @Override
    public ImportMode getImportMode() {
        String importModeId = (String)this.getProperty(ProjectProperties.IMPORT_MODE_ID);
        if (TextUtils.hasContent((String)importModeId)) {
            return ImportMode.valueOf(importModeId);
        }
        return ImportMode.COPY;
    }

    @Override
    public void setImportMode(ImportMode mode) {
        this.setProperty(ProjectProperties.IMPORT_MODE_ID, (mode != null ? mode : ImportMode.COPY).getId());
    }
}

