/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.function.ThrowableBiConsumer;
import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.creator.IProjectHandler;
import com.silabs.ss.framework.project.api.core.solution.NewSolutionTemplateHelper;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.performance.recording.LoggingFeature;
import com.silabs.ss.platform.performance.recording.PerformanceMetadata;
import com.silabs.ss.platform.performance.recording.StopWatch;
import com.silabs.ss.platform.performance.recording.rcp.PerformanceManager;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public final class TemplateProjectCreationEngine {
    public static final String PROJECT_CREATED = "PROJECT_CREATED";
    public static final String ALL_PROJECTS_CREATED = "ALL_PROJECTS_CREATED";
    private final NewSolutionTemplateHelper solution;
    private final IWriteableProjectDescriptor[] projectDescs;
    private final ThrowableBiConsumer<String, ProjectData, CoreException> callback;
    private final LinkedHashMap<IWriteableProjectDescriptor, IProjectHandler> handlers = new LinkedHashMap();

    public static TemplateProjectCreationEngine create(NewSolutionTemplateHelper solution, IWriteableProjectDescriptor[] projectDescs, ThrowableBiConsumer<String, ProjectData, CoreException> callback) {
        return new TemplateProjectCreationEngine(solution, projectDescs, callback);
    }

    private TemplateProjectCreationEngine(NewSolutionTemplateHelper solution, IWriteableProjectDescriptor[] projectDescs, ThrowableBiConsumer<String, ProjectData, CoreException> callback) {
        this.solution = solution != null ? solution : NewSolutionTemplateHelper.create(new IWriteableProjectDescriptor[0]);
        this.projectDescs = projectDescs;
        this.callback = callback;
    }

    public void runCreateConvert(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (this.projectDescs.length == 0) {
            return;
        }
        int tasks = this.solution.isSolution() ? this.projectDescs.length + 2 : this.projectDescs.length;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)tasks);
        this.solution.runPreSolutionProcess((IProgressMonitor)subMonitor.split(1));
        IWriteableProjectDescriptor[] iWriteableProjectDescriptorArray = this.projectDescs;
        int n = this.projectDescs.length;
        int n2 = 0;
        while (n2 < n) {
            IWriteableProjectDescriptor projectDesc = iWriteableProjectDescriptorArray[n2];
            IProjectType projectType = projectDesc.getProjectType();
            if (projectType == null) {
                throw Activator.reporter.newCoreException("The project type needed for this project (" + String.valueOf(projectType) + ") is not registered", null);
            }
            IProjectHandler projectHandler = projectType.createProjectHandler(projectDesc);
            this.solution.injectSolutionData(projectHandler);
            this.handlers.put(projectDesc, projectHandler);
            StopWatch stopWatch = PerformanceManager.INSTANCE.logStartMap(LoggingFeature.ALL, "SLSProjectHandlerEngine.runCreateConvert", null, PerformanceMetadata::none);
            TemplateProjectCreationEngine.createConvertProject(projectDesc, projectHandler, (IProgressMonitor)subMonitor.split(1));
            stopWatch.done();
            subMonitor.checkCanceled();
            this.callback.accept((Object)PROJECT_CREATED, (Object)new ProjectData(projectDesc, projectHandler));
            ++n2;
        }
        this.solution.runSolutionProcess((IProgressMonitor)subMonitor.split(1));
        this.callback.accept((Object)ALL_PROJECTS_CREATED, (Object)new ProjectData(this.projectDescs[0], this.handlers.get(this.projectDescs[0])));
    }

    public static void createConvertProject(IWriteableProjectDescriptor projectDesc, IProjectHandler projectHandler, IProgressMonitor monitor) throws CoreException {
        IWriteableProjectDescriptor projDescr = projectHandler.getProjectDescriptor();
        if (projDescr.buildConfigurationDescriptors().isEmpty() && !((Boolean)projDescr.getProperty(BuildConfigProperties.IS_CONFIG_RESOLVED)).booleanValue()) {
            throw Activator.reporter.newCoreException("no configurations applied to project");
        }
        projectHandler.createOrConvertProject(monitor);
    }

    public class ProjectData {
        public final IWriteableProjectDescriptor projDesc;
        public final IProjectHandler handler;

        public ProjectData(IWriteableProjectDescriptor projDesc, IProjectHandler handler) {
            this.projDesc = projDesc;
            this.handler = handler;
        }
    }
}

