/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine.operations;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseLanguageAwareProjectSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddLibrarySettingOperation;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.internal.core.Activator;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddLibraryFileSettingOperation
extends BaseLanguageAwareProjectSettingOperation
implements IAddLibrarySettingOperation {
    private String name;
    private URI libURI;

    public AddLibraryFileSettingOperation(IProjectEngineSession session, String buildConfig, MLibraryFile file) {
        super(session, buildConfig, null, (MBuildSetting)file);
        if (!TextUtils.isEmpty((String)file.getName())) {
            this.name = session.getProjectModel().resolveString(file.getName());
        } else {
            try {
                this.libURI = session.getProjectModel().resolveURI(file.getUri(), false);
                this.libURI = session.getProjectModel().encodeProjectURI(this.libURI);
            }
            catch (IllegalArgumentException e) {
                Activator.reporter.logError("invalid library file: " + file.getUri(), (Throwable)e);
                this.libURI = URI.create("");
            }
        }
    }

    @Override
    public final void executeProcess(IProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        handler.handleAddLibraryFileSettingOperation(this, monitor);
    }

    @Override
    public String toString() {
        return super.toString() + ": <" + (this.name != null ? this.name : this.libURI.toString()) + ">";
    }

    public String getLibraryName() {
        return this.name;
    }

    @Override
    public URI getLibraryURI() {
        return this.libURI;
    }
}

