/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine.operations;

import com.silabs.ss.framework.project.api.core.engine.IBaseProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.model.MDescribable;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ReportErrorOperation
implements IProjectEngineOperation {
    private IProjectEngineSession session;
    private Exception e;
    private MEntry content;

    public ReportErrorOperation(IProjectEngineSession session, MEntry entry, File contentFile, IOException e) {
        this.session = session;
        this.content = entry;
        this.e = e;
    }

    public ReportErrorOperation(Exception e) {
        this.e = e;
    }

    @Override
    public IProjectEngineSession getSession() {
        return this.session;
    }

    @Override
    public void executeProcess(IBaseProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        handler.handleReportError(this, monitor);
    }

    @Override
    public void executeProcess(IProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        handler.handleReportError(this, monitor);
    }

    public void throwException() throws CoreException {
        throw Activator.reporter.newCoreException(this.getErrorMsg(), (Throwable)this.getException());
    }

    public Exception getException() {
        return this.e;
    }

    public String getErrorMsg() {
        String message = this.getException().getMessage();
        String entryMsg = Optional.ofNullable(this.content).map(MDescribable::getName).map(n -> "Problem with " + n).orElse("");
        return entryMsg + " - " + message;
    }
}

