/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.entity;

import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectWithBuildConfigurationId;
import com.silabs.ss.framework.project.api.core.adapters.IProjectModelSetupAdapter;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingEngine;
import com.silabs.ss.framework.project.api.toolchain.core.IToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.framework.project.api.toolchain.core.ToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.adapters.IToolchainOptionAdapter;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationManager;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfiguration;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelOptionEngine;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.board.core.IBoard;
import com.silabs.ss.platform.api.content.board.core.IBoardManager;
import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.content.part.core.IPartManager;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.BaseDescriptorEntity;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptorEntity;
import com.silabs.ss.platform.api.sdk.core.ISDK;
import com.silabs.ss.platform.api.sdk.core.ISDKManager;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BuildConfiguration
extends BaseDescriptorEntity<IBuildConfigurationDescriptor>
implements IBuildConfiguration {
    private IProjectEntity projectEntity;
    private boolean needsApplyStock = false;

    public BuildConfiguration(IProjectEntity projectEntity, IBuildConfigurationDescriptor desc) {
        super((IDescriptor)desc, Activator.id());
        this.projectEntity = projectEntity;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.projectEntity == null ? 0 : this.projectEntity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)obj;
        return !(this.projectEntity == null ? other.projectEntity != null : !this.projectEntity.equals(other.projectEntity));
    }

    public String toString() {
        return super.toString() + " in " + (this.getParent() != null ? this.getParent().getName() : " no project");
    }

    protected String getDefaultPropertyScope() {
        return "buildConfig";
    }

    public IProjectEntity getParent() {
        return this.projectEntity;
    }

    @Override
    public BuildConfiguration copy() {
        return (BuildConfiguration)super.copy();
    }

    @Override
    public Collection<IToolOption> getStockOptions() {
        Collection<IToolOption> addlStocks;
        ArrayList<IToolOption> stocks = null;
        IStockConfigurationDescriptor stockDesc = this.getStockConfiguration();
        if (stockDesc != null) {
            IStockConfigurationManager stockConfigurationManager = this.getManager(IStockConfigurationManager.class);
            stocks = new ArrayList(stockDesc.getStockOptions(stockConfigurationManager));
        }
        if (!(addlStocks = ((IBuildConfigurationDescriptor)this.getDescriptor()).getAdditionalStockOptions()).isEmpty()) {
            if (stocks != null) {
                stocks = new ArrayList<IToolOption>(stocks);
                stocks.addAll(addlStocks);
            } else {
                stocks = addlStocks;
            }
        }
        if (stocks == null) {
            stocks = Collections.emptyList();
        } else {
            this.realizeToolOptions(stocks);
        }
        return stocks;
    }

    protected void realizeToolOptions(Collection<IToolOption> stocks) {
        IToolchain tc;
        try {
            tc = this.getToolchain();
        }
        catch (CoreException e) {
            Activator.reporter.logError("failed to convert stock options", (Throwable)e);
            return;
        }
        IToolchainOptionAdapter adapter = (IToolchainOptionAdapter)tc.getAdapter(IToolchainOptionAdapter.class);
        if (adapter == null) {
            return;
        }
        IOptionMappingEngine mapper = adapter.getGenericOptionMappingRegistry().createOptionMappingEngine();
        Collection<MToolOption> resolvedOpts = ProjectModelOptionEngine.resolveToolOptions(Arrays.asList(mapper), stocks);
        LinkedHashMap<Pair, ToolOption> flatMap = new LinkedHashMap<Pair, ToolOption>();
        for (MToolOption spec : resolvedOpts) {
            ToolOption opt = new ToolOption(spec.getToolId(), spec.getOptionId(), spec.getValue(), spec.getToolListOptions().stream().map(MToolListOption::getValue));
            opt.setBuiltin(true);
            flatMap.put(new Pair((Object)opt.getToolIdPattern(), (Object)opt.getOptionIdRepl()), opt);
        }
        stocks.clear();
        stocks.addAll(flatMap.values());
    }

    @Override
    public IStockConfigurationDescriptor getStockConfiguration() {
        String stockConfigId = (String)this.getProperty(BuildConfigProperties.STOCK_CONFIG_ID);
        IStockConfigurationDescriptor stockDesc = (IStockConfigurationDescriptor)this.getManager(IStockConfigurationManager.class).findDescriptor(stockConfigId);
        return stockDesc;
    }

    @Override
    public IBoard[] getBoards() throws CoreException {
        ArrayList<IBoard> compatBoards = new ArrayList<IBoard>();
        String[] stringArray = ((IBuildConfigurationDescriptor)this.getDescriptor()).getBoardIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String boardId = stringArray[n2];
            IBoard board = (IBoard)this.getManager(IBoardManager.class).getCompatible(boardId);
            if (board != null) {
                compatBoards.add(board);
            }
            ++n2;
        }
        return compatBoards.toArray(new IBoard[compatBoards.size()]);
    }

    @Override
    public IPart getPart() throws CoreException {
        return (IPart)this.getManager(IPartManager.class).getCompatible(((IBuildConfigurationDescriptor)this.getDescriptor()).getPartId());
    }

    @Override
    public IToolchain getToolchain() throws CoreException {
        return (IToolchain)this.getManager(IToolchainManager.class).getCompatible(((IBuildConfigurationDescriptor)this.getDescriptor()).getToolchainId());
    }

    @Override
    public ISDK getSdk() throws CoreException {
        return (ISDK)this.getManager(ISDKManager.class).getCompatible(((IBuildConfigurationDescriptor)this.getDescriptor()).getSdkId());
    }

    protected <T> T getManager(Class<T> clazz) {
        if (clazz == ISDKManager.class) {
            return clazz.cast(SDK.manager());
        }
        if (clazz == IToolchainManager.class) {
            return clazz.cast(Toolchain.manager());
        }
        if (clazz == IPartManager.class) {
            return clazz.cast(Part.manager());
        }
        if (clazz == IBoardManager.class) {
            return clazz.cast(Board.manager());
        }
        if (clazz == IStockConfigurationManager.class) {
            return clazz.cast(StockConfiguration.manager());
        }
        return null;
    }

    @Override
    public void setup(IProjectModel projectModel, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Setting up " + this.getLabel()), (int)4);
        ISDK sdk = null;
        try {
            if (!TextUtils.isEmpty((String)((IBuildConfigurationDescriptor)this.getDescriptor()).getSdkId())) {
                sdk = this.getSdk();
            }
        }
        catch (CoreException coreException) {}
        IToolchain toolchain = null;
        try {
            if (!TextUtils.isEmpty((String)((IBuildConfigurationDescriptor)this.getDescriptor()).getToolchainId())) {
                toolchain = this.getToolchain();
            }
        }
        catch (CoreException coreException) {}
        IPart part = null;
        try {
            if (!TextUtils.isEmpty((String)((IBuildConfigurationDescriptor)this.getDescriptor()).getPartId())) {
                part = this.getPart();
            }
        }
        catch (CoreException coreException) {}
        subMonitor.newChild(1);
        MConfiguration conf = projectModel.getModel().findConfigurationByName(this.getName());
        if (conf == null) {
            return;
        }
        IDescriptorEntity[] iDescriptorEntityArray = new IDescriptorEntity[]{sdk, toolchain, part};
        int n = iDescriptorEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDescriptorEntity ent = iDescriptorEntityArray[n2];
            if (ent != null) {
                IProjectModelSetupAdapter pmsa = (IProjectModelSetupAdapter)ent.getAdapter(IProjectModelSetupAdapter.class);
                if (pmsa != null) {
                    pmsa.setupProjectModel((IBuildConfigurationDescriptor)this.getDescriptor(), projectModel, conf, (IProgressMonitor)subMonitor.newChild(1));
                } else {
                    subMonitor.newChild(1);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean needsApplyStock() {
        return this.needsApplyStock;
    }

    @Override
    public void setNeedsApplyStock(boolean needsApplyStock) {
        this.needsApplyStock = needsApplyStock;
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object obj = this.getParent().getAdapter(adapter);
        if (obj != null) {
            return (T)obj;
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public Collection<ProjectWithBuildConfigurationId> getProjectDependencies() {
        return ((IBuildConfigurationDescriptor)this.getDescriptor()).getProjectDependencies();
    }

    @Override
    public void setProjectDependencies(Collection<ProjectWithBuildConfigurationId> dependencies) {
        ((IBuildConfigurationDescriptor)this.getDescriptor()).setProjectDependencies(dependencies);
    }
}

