/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.external.ImportProjectInfo;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.TimeLimit;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ImportProjectScanningEngine {
    private Set<File> oldLocations;
    private Set<File> locations = new HashSet<File>();
    private Set<IExternalType> extProjectTypes;
    private TimeLimit timeLimit;
    private Set<ImportProjectInfo> fullResults;
    private Map<File, Long> dirTimeMap;
    private boolean ignoreDirectories;
    private boolean recurse;
    private boolean singleProject;
    private IIDE selectedIDE;
    private static final String SOLUTION_TYPE = "com.silabs.ss.framework.ide.project.core.SlsArchiveExternalSolutionType";

    public ImportProjectScanningEngine() {
        this(IDEPreferenceManager.getPreferredIDE());
    }

    public ImportProjectScanningEngine(IIDE importedIDE) {
        this.oldLocations = new HashSet<File>();
        this.extProjectTypes = new HashSet<IExternalType>();
        this.fullResults = new HashSet<ImportProjectInfo>();
        this.dirTimeMap = new HashMap<File, Long>();
        this.selectedIDE = importedIDE;
    }

    public void setSelectedIDE(IIDE selectedIDE) {
        this.selectedIDE = selectedIDE;
    }

    public void setRecurse(boolean recurse) {
        if (this.recurse != recurse) {
            this.reset();
        }
        this.recurse = recurse;
    }

    public void setSingleProjectMode(boolean singleProject) {
        this.singleProject = singleProject;
    }

    public void setTimeLimit(TimeLimit timeLimit) {
        if (this.timeLimit == null && timeLimit != null) {
            this.reset();
        }
        this.timeLimit = timeLimit;
    }

    public void setIgnoreDirectoryProjects(boolean ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public void setLocations(List<File> locations) {
        Iterator<File> locIter = this.locations.iterator();
        while (locIter.hasNext()) {
            File loc = locIter.next();
            if (locations.contains(loc)) continue;
            locIter.remove();
            this.oldLocations.remove(loc);
            Iterator<ImportProjectInfo> iter = this.fullResults.iterator();
            while (iter.hasNext()) {
                ImportProjectInfo prj = iter.next();
                if (!prj.getRoot().equals(loc)) continue;
                iter.remove();
            }
        }
        for (File loc : locations) {
            if (!this.locations.add(loc)) continue;
            this.oldLocations.remove(loc);
        }
    }

    public void setExtProjectTypes(List<IExternalType> extProjectTypes) {
        if (extProjectTypes == null) {
            extProjectTypes = Arrays.asList(ProjectType.manager().getAllExternalTypes());
        }
        boolean changed = false;
        Iterator<IExternalType> extTypeIter = this.extProjectTypes.iterator();
        while (extTypeIter.hasNext()) {
            IExternalType extTyp = extTypeIter.next();
            if (extProjectTypes.contains(extTyp)) continue;
            extTypeIter.remove();
            changed = true;
            Iterator<ImportProjectInfo> iter = this.fullResults.iterator();
            while (iter.hasNext()) {
                ImportProjectInfo prj = iter.next();
                if (!prj.getExtProjectType().equals(extTyp)) continue;
                iter.remove();
            }
        }
        if (this.extProjectTypes.addAll(extProjectTypes)) {
            changed = true;
        }
        if (changed) {
            this.oldLocations.clear();
        }
    }

    public void reset() {
        this.oldLocations.clear();
        this.fullResults.clear();
        this.dirTimeMap.clear();
    }

    public Collection<ImportProjectInfo> scanProjects(ImportMode importMode, IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning... ", (int)this.locations.size());
        for (File loc : this.locations) {
            try {
                loc = loc.getCanonicalFile();
            }
            catch (IOException iOException) {}
            if (this.oldLocations.contains(loc)) {
                subMon.newChild(1);
                continue;
            }
            this.scanDirectory(importMode, loc, loc, (IProgressMonitor)subMon.newChild(1));
            if (subMon.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.oldLocations.add(loc);
        }
        Set<ImportProjectInfo> filteredResults = this.filterProjects();
        return filteredResults;
    }

    private void scanDirectory(ImportMode importMode, File root, File loc, IProgressMonitor monitor) {
        File[] files;
        boolean found = false;
        File searchDir = loc;
        if (searchDir.isFile()) {
            searchDir = searchDir.getParentFile();
        }
        if ((files = searchDir.listFiles()) == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)searchDir.toString(), (int)2);
        for (IExternalType extType : this.extProjectTypes) {
            ImportProjectRecord[] prjs;
            IExternalImporter importProjectType = extType.getImportType();
            if (importProjectType == null || (prjs = importProjectType.findProjects(searchDir)) == null || prjs.length == 0) continue;
            long newestFileTime = this.timeLimit != null ? this.getNewestFileTime(searchDir, 0, (IProgressMonitor)subMonitor) : 0L;
            ImportProjectRecord[] importProjectRecordArray = prjs;
            int n = prjs.length;
            int n2 = 0;
            while (n2 < n) {
                ImportProjectRecord prj = importProjectRecordArray[n2];
                ImportProjectInfo info = new ImportProjectInfo(extType, root, prj, newestFileTime);
                this.fullResults.add(info);
                ++n2;
            }
            found = true;
        }
        subMonitor.newChild(1);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!found && this.recurse) {
            subMonitor = subMonitor.newChild(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File dir = fileArray[n3];
                if (dir.isDirectory()) {
                    if (this.ignoreDirectory(dir)) {
                        subMonitor.newChild(1);
                    } else {
                        this.scanDirectory(importMode, root, dir, (IProgressMonitor)subMonitor.newChild(1));
                        if (subMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                } else {
                    subMonitor.newChild(1);
                }
                ++n3;
            }
        } else {
            subMonitor.newChild(1);
        }
    }

    private ImportProjectInfo findMatchByLocation(File location) {
        for (ImportProjectInfo ex : this.fullResults) {
            if (!ex.getProjectFile().equals(location)) continue;
            return ex;
        }
        return null;
    }

    protected boolean ignoreDirectory(File dir) {
        return dir.getName().matches("CVS|\\.svn|\\.git|\\.cp|\\$Recycle.Bin");
    }

    private boolean isTypeMoreSpecific(IExternalType newType, IExternalType oldType) {
        while (newType != null) {
            String superType = newType.getImportType().getSuperExternalProjectTypeId();
            if (superType == null) break;
            newType = ProjectType.manager().findExternalType(superType);
            if (!oldType.equals(newType)) continue;
            return true;
        }
        return false;
    }

    private Set<ImportProjectInfo> filterProjects() {
        HashSet<ImportProjectInfo> filteredResults = new HashSet<ImportProjectInfo>();
        for (ImportProjectInfo info : this.fullResults) {
            ImportProjectInfo ex;
            if (!this.singleProject && (ex = this.findMatchByLocation(info.getProjectFile())) != null && ex != info && !this.isTypeMoreSpecific(info.getExtProjectType(), ex.getExtProjectType())) continue;
            if (this.timeLimit != null) {
                long timeLimitMs = this.timeLimit.getDate().getTimeInMillis();
                if (info.getNewestFileTime() < timeLimitMs) continue;
            }
            if (this.ignoreDirectories && info.getProjectFile().isDirectory()) continue;
            filteredResults.add(info);
        }
        if (!this.singleProject) {
            ImportProjectInfo[] importProjectInfoArray = filteredResults.toArray(new ImportProjectInfo[filteredResults.size()]);
            int n = importProjectInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                File prjDir;
                ImportProjectInfo dirInfo;
                ImportProjectInfo info;
                info = importProjectInfoArray[n2];
                if (info.getProjectFile().isFile() && (dirInfo = this.findMatchByLocation(prjDir = info.getProjectFile().getParentFile())) != null && dirInfo != info && this.isTypeMoreSpecific(info.getExtProjectType(), dirInfo.getExtProjectType())) {
                    filteredResults.remove(dirInfo);
                }
                ++n2;
            }
        }
        this.determineImportableProjectNames(filteredResults);
        return filteredResults;
    }

    private long getNewestFileTime(File loc, int depth, IProgressMonitor monitor) {
        Long newest = this.dirTimeMap.get(loc);
        if (newest == null) {
            newest = this.scanNewestFileTime(loc, depth, monitor);
            this.dirTimeMap.put(loc, newest);
        }
        return newest;
    }

    private long scanNewestFileTime(File loc, int depth, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return 0L;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        long max = 0L;
        File[] list = loc.listFiles();
        subMonitor.newChild(1);
        if (list != null) {
            subMonitor = SubMonitor.convert((IProgressMonitor)subMonitor, (int)list.length);
            File[] fileArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (subMonitor.isCanceled()) {
                    return 0L;
                }
                subMonitor = subMonitor.newChild(1);
                long tm = depth < 3 && file.isDirectory() ? this.getNewestFileTime(file, depth + 1, (IProgressMonitor)subMonitor) : file.lastModified();
                if (tm > max) {
                    max = tm;
                }
                ++n2;
            }
        }
        subMonitor.setWorkRemaining(0);
        return max;
    }

    private void determineImportableProjectNames(Set<ImportProjectInfo> detectedProjects) {
        HashSet<String> projNames = new HashSet<String>();
        for (ImportProjectInfo info : detectedProjects) {
            if (SOLUTION_TYPE.equals(info.getExtProjectType().getId())) continue;
            Path projLoc = new Path(info.getProjectDirectory().getAbsolutePath());
            String projName = this.selectedIDE.getUniqueProjectName((IPath)projLoc, info.getProjectName(), projNames.toArray(new String[0]));
            if (TextUtils.hasContent((String)projName)) {
                info.setProjectName(projName);
            }
            if (this.singleProject) continue;
            projNames.add(projName);
        }
    }
}

