/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external.report;

import com.silabs.java.utils.Pair;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.descriptor.core.property.model.PropertyConversionUtils;
import com.silabs.ss.platform.api.rcp.core.html.HtmlContainerNode;
import com.silabs.ss.platform.api.rcp.core.html.HtmlTable;
import com.silabs.ss.platform.api.rcp.core.html.HtmlText;
import com.silabs.ss.platform.api.rcp.core.html.IHtmlNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SettingsSiteCollator {
    private static final int NUM_COLUMNS = 6;
    private HtmlTable table;
    private Map<IProperty, List<Pair<SettingEntry, SettingEntry>>> settingMaps;
    private boolean showIds;

    public SettingsSiteCollator(HtmlTable table, boolean showIds) {
        this.table = table;
        this.showIds = showIds;
        this.settingMaps = new LinkedHashMap<IProperty, List<Pair<SettingEntry, SettingEntry>>>();
    }

    public void addMapping(MConvertedOption ext, MConvertedOption intr) {
        SettingEntry incoming = this.getSettingEntry(ext);
        if (incoming == null) {
            assert (false);
            return;
        }
        SettingEntry outgoing = this.getSettingEntry(intr);
        List<Pair<SettingEntry, SettingEntry>> list = this.settingMaps.get(incoming.property);
        if (list == null) {
            list = new ArrayList<Pair<SettingEntry, SettingEntry>>(1);
            this.settingMaps.put(incoming.property, list);
        }
        Pair pair = new Pair((Object)incoming, (Object)outgoing);
        for (Pair<SettingEntry, SettingEntry> exist : list) {
            if (exist.first == null || !((SettingEntry)exist.first).property.equals((Object)incoming.property) || (exist.second == null || !((SettingEntry)exist.second).property.equals((Object)outgoing.property)) && (exist.second != null || outgoing != null)) continue;
            ((SettingEntry)exist.first).value = incoming.value;
            if (exist.second != null && outgoing != null) {
                ((SettingEntry)exist.second).value = outgoing.value;
            }
            return;
        }
        list.add((Pair<SettingEntry, SettingEntry>)pair);
    }

    protected SettingEntry getSettingEntry(MConvertedOption spec) {
        if (spec == null) {
            return null;
        }
        IPropertyGroup specTool = Property.registry().findPropertyGroup(spec.getToolId());
        IProperty specOpt = (IProperty)Property.registry().findDescriptor(spec.getOptionId());
        if (specTool != null && specOpt != null) {
            String value = PropertyConversionUtils.stringizeValue((IProperty)specOpt, (Object)spec.getValue());
            if (this.showIds) {
                return new SettingEntry(specOpt, spec.getToolId(), spec.getOptionId(), value);
            }
            String tool = specTool.getLabel();
            String option = specOpt.getLabel();
            if (specOpt.getType().isEnum()) {
                List enums = specOpt.getType().getEnumValues();
                int idx = enums.indexOf(value);
                List enumLabels = specOpt.getType().getEnumLabels();
                if (idx >= 0 && enumLabels != null && idx < enumLabels.size()) {
                    value = (String)enumLabels.get(idx);
                }
            }
            return new SettingEntry(specOpt, tool, option, value);
        }
        Activator.reporter.logError("unregistered setting for option: " + String.valueOf(spec));
        return null;
    }

    public void flush() {
        Comparator<IProperty> comparator = new Comparator<IProperty>(){

            @Override
            public int compare(IProperty o1, IProperty o2) {
                int diff = ((IPropertyGroup)o1.getParent()).getLabel().compareTo(((IPropertyGroup)o2.getParent()).getLabel());
                if (diff != 0) {
                    return diff;
                }
                diff = o1.getLabel().compareTo(o2.getLabel());
                return diff;
            }
        };
        IProperty[] incomingEntries = this.settingMaps.keySet().toArray(new IProperty[this.settingMaps.keySet().size()]);
        Arrays.sort(incomingEntries, comparator);
        IProperty[] iPropertyArray = incomingEntries;
        int n = incomingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty incoming = iPropertyArray[n2];
            List<Pair<SettingEntry, SettingEntry>> list = this.settingMaps.get(incoming);
            Collection[] columnDatas = new Collection[6];
            int i = 0;
            while (i < columnDatas.length) {
                columnDatas[i] = i == 5 ? new ArrayList(1) : new LinkedHashSet(1);
                ++i;
            }
            for (Pair<SettingEntry, SettingEntry> pair : list) {
                this.updateRow(columnDatas, (SettingEntry)pair.first, (SettingEntry)pair.second);
            }
            IHtmlNode[] columns = new IHtmlNode[columnDatas.length];
            int i2 = 0;
            while (i2 < columns.length) {
                columns[i2] = this.makeColumnNode(columnDatas[i2]);
                ++i2;
            }
            this.table.addRow(columns);
            ++n2;
        }
        this.settingMaps.clear();
    }

    private IHtmlNode makeColumnNode(Collection<String> collection) {
        if (collection.isEmpty()) {
            return new HtmlText("");
        }
        if (collection.size() == 1) {
            return new HtmlText(collection.iterator().next());
        }
        HtmlContainerNode node = new HtmlContainerNode("", "ul");
        for (String str : collection) {
            HtmlContainerNode sub = new HtmlContainerNode("", "li");
            sub.add((IHtmlNode)new HtmlText(str));
            node.add((IHtmlNode)sub);
        }
        return node;
    }

    private void updateRow(Collection<String>[] columns, SettingEntry first, SettingEntry second) {
        if (first != null) {
            columns[0].add(first.tool);
            columns[1].add(first.option);
            columns[2].add(first.value);
        }
        if (second != null) {
            columns[3].add(second.tool);
            columns[4].add(second.option);
            columns[5].add(second.value);
        }
    }

    static class SettingEntry {
        String tool;
        String option;
        String value;
        IProperty property;

        public SettingEntry(IProperty property, String tool, String option, String value) {
            this.property = property;
            this.tool = tool;
            this.option = option;
            this.value = value;
        }
    }
}

