/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.templates;

import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ImportModeUtils;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.IWriteableTemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.Template;
import com.silabs.ss.framework.project.api.templates.TemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfigurationProperties;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

public class ProjectTemplateUtils {
    public static final String PROJECT_TEMPLATE_NAMESPACE = "projectTemplate";
    private static final String C_EXE_PROJECT_TEMPLATE_ID = "cExeProject";
    private static final String CPP_EXE_PROJECT_TEMPLATE_ID = "cppExeProject";
    private static final String STATIC_LIB_TEMPLATE_ID = "staticLibProject";
    private static final String EMPTY_PROJECT_TEMPLATE_NAME = "emptyProjectTemplate";
    private static final String EMPTY_PROJECT_TEMPLATE_ID = "projectTemplate.emptyProjectTemplate";

    private ProjectTemplateUtils() {
    }

    public static IProjectDescriptor.BuildArtifactType fetchBuildArtifactType(MProject proj) {
        IProjectDescriptor.BuildArtifactType artifactType = IProjectDescriptor.BuildArtifactType.EXE;
        String artifactString = (String)proj.getProperties().get((Object)("projectCommon." + String.valueOf(ProjectCommonProperties.BUILD_ARTIFACT_TYPE)));
        if (artifactString == null) {
            artifactString = (String)proj.getProperties().get(ProjectCommonProperties.BUILD_ARTIFACT_TYPE);
        }
        if (artifactString != null) {
            try {
                artifactType = IProjectDescriptor.BuildArtifactType.valueOf(artifactString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Activator.reporter.logError("Unexpected build artifact type:" + artifactString);
            }
        }
        return artifactType;
    }

    public static ITemplateDescriptor getEmptyProjectTemplate() {
        ITemplateDescriptor template = (ITemplateDescriptor)Template.manager().findDescriptor(EMPTY_PROJECT_TEMPLATE_ID);
        if (template != null) {
            return template;
        }
        TemplateDescriptor emptyTemplate = new TemplateDescriptor();
        emptyTemplate.setName(EMPTY_PROJECT_TEMPLATE_NAME);
        emptyTemplate.setProperty(TemplateProperties.NAMESPACE, (Object)PROJECT_TEMPLATE_NAMESPACE);
        emptyTemplate.setProperty(CoreProperties.HIDDEN, (Object)true);
        ProjectTemplateUtils.setDefaults((IWriteableTemplateDescriptor)emptyTemplate);
        Template.manager().registerDescriptor((IDescriptor)emptyTemplate);
        return emptyTemplate;
    }

    public static ITemplateDescriptor getEmptyCProjectTemplate(String sdkId) {
        return ProjectTemplateUtils.getProjectTemplate(sdkId, C_EXE_PROJECT_TEMPLATE_ID);
    }

    public static ITemplateDescriptor getEmptyCPPProjectTemplate(String sdkId) {
        return ProjectTemplateUtils.getProjectTemplate(sdkId, CPP_EXE_PROJECT_TEMPLATE_ID);
    }

    public static ITemplateDescriptor getStaticLibraryTemplate(String sdkId) {
        return ProjectTemplateUtils.getProjectTemplate(sdkId, STATIC_LIB_TEMPLATE_ID);
    }

    public static ITemplateDescriptor getProjectTemplate(String sdkId, String id) {
        String templateId = "hardwareConfiguratorProject".equals(id) ? MessageFormat.format("{0}.{1}.{2}", "projectModelHwconf", sdkId, id) : MessageFormat.format("{0}.{1}.{2}", PROJECT_TEMPLATE_NAMESPACE, sdkId, id);
        return (ITemplateDescriptor)Template.manager().findDescriptor(templateId);
    }

    public static void setDefaults(IWriteableTemplateDescriptor template) {
        template.setProperty(TemplateProperties.IMPORT_MODE_COMPATIBILITY, (Object)ImportModeUtils.getDefaultTemplateImportMode());
        Collection tcCompat = (Collection)template.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
        tcCompat.add("-com.silabs.ss.framework.project.core.noToolChain:0.0.0");
        if (tcCompat.size() == 1) {
            tcCompat.add(".*");
        }
        template.setProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY, (Object)tcCompat);
        Collection stockCompat = (Collection)template.getProperty(StockConfigurationProperties.STOCK_CONFIG_COMPATIBILITY);
        if (stockCompat.isEmpty()) {
            stockCompat.add("com.silabs.ss.framework.project.toolchain.core.debug");
            stockCompat.add("com.silabs.ss.framework.project.toolchain.core.release");
            template.setProperty(StockConfigurationProperties.STOCK_CONFIG_COMPATIBILITY, (Object)stockCompat);
        }
    }

    public static void propagateTemplatePropertiesToObjectMap(ITemplate template, Map<String, Object> objectMap) {
        String[] stringArray = template.getPropertyAccess().getNonDefaultPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String shortKey;
                String key;
                block5: {
                    shortKey = key = stringArray[n2];
                    IProperty prop = (IProperty)template.getPropertyMapper().findProperty(key);
                    if (prop == null) break block5;
                    if (!prop.getId().startsWith("template.")) break block6;
                    shortKey = prop.getName();
                }
                if (!objectMap.containsKey(shortKey)) {
                    objectMap.put(shortKey, template.getPropertyAccess().getValueString(key));
                }
            }
            ++n2;
        }
    }

    public static void propagateTemplatePropertiesToVariableMap(ITemplate template, Map<String, String> varMap) {
        String[] stringArray = template.getPropertyAccess().getNonDefaultPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String val;
                String shortKey;
                String key;
                block5: {
                    shortKey = key = stringArray[n2];
                    IProperty prop = (IProperty)template.getPropertyMapper().findProperty(key);
                    if (prop == null) break block5;
                    if (!prop.getId().startsWith("template.")) break block6;
                    shortKey = prop.getName();
                }
                if (!varMap.containsKey(shortKey) && (val = template.getPropertyAccess().getValueString(key)) != null) {
                    varMap.put(shortKey, val);
                }
            }
            ++n2;
        }
    }

    public static void correctLabels(IWriteableTemplateDescriptor writeable) {
        switch (writeable.getName()) {
            case "staticLibProject": {
                writeable.setLabel("Empty C Library Project");
                break;
            }
            case "cExeProject": {
                writeable.setLabel("Empty C Project");
                break;
            }
            case "cppExeProject": {
                writeable.setLabel("Empty C++ Project");
            }
        }
    }
}

