/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.utils;

import java.io.File;
import java.util.regex.Pattern;

public final class ProjectFileUtils {
    public static final String DOT_H = "(?i).*\\.h";
    private static final String DOT_XML = "(?i).*\\.xml";
    public static final String DOT_C = "(?i).*\\.c";
    public static final String DOT_CPP = "(?i).*\\.(cpp)";
    public static final String DOT_ASM = "(?i).*\\.(asm||s|s79)";
    public static final String DOT_A = ".*\\.[a,A]|.*\\.so|.*\\.SO|.*\\.lib|.*\\.LIB|.*\\.o|.*\\.O";
    private static final Pattern CPP_SOURCE_PAT = Pattern.compile("(?i).*\\.(cpp|cxx|cc)");
    private static final Pattern DOT_ASM_2_PAT = Pattern.compile("(?i).*\\.(asm|s|s79)");
    private static final Pattern DOT_HPP_PAT = Pattern.compile("(?i).*\\.(h|hpp|hxx|hh)");
    private static final Pattern DOT_H_PAT = Pattern.compile("(?i).*\\.h");
    private static final Pattern DOT_XML_PAT = Pattern.compile("(?i).*\\.xml");
    private static final Pattern DOT_C_PAT = Pattern.compile("(?i).*\\.c");
    private static final Pattern DOT_A_PAT = Pattern.compile(".*\\.[a,A]|.*\\.so|.*\\.SO|.*\\.lib|.*\\.LIB|.*\\.o|.*\\.O");

    private ProjectFileUtils() {
    }

    public static boolean isLibraryFile(File file) {
        return ProjectFileUtils.handleFile(file, DOT_A_PAT);
    }

    public static boolean isLibraryFileName(String name) {
        return ProjectFileUtils.handleAll(name, DOT_A_PAT);
    }

    public static boolean isCFile(File file) {
        return ProjectFileUtils.handleFile(file, DOT_C_PAT);
    }

    public static boolean isCFileName(String name) {
        return ProjectFileUtils.handleAll(name, DOT_C_PAT);
    }

    public static boolean isCppFile(File file) {
        return ProjectFileUtils.handleFile(file, CPP_SOURCE_PAT);
    }

    public static boolean isCppFileName(String name) {
        return ProjectFileUtils.handleAll(name, CPP_SOURCE_PAT);
    }

    public static boolean isAsmFile(File file) {
        return ProjectFileUtils.handleFile(file, DOT_ASM_2_PAT);
    }

    public static boolean isAsmFileName(String name) {
        return ProjectFileUtils.handleAll(name, DOT_ASM_2_PAT);
    }

    public static boolean isCHeaderFile(File file) {
        return ProjectFileUtils.handleFile(file, DOT_H_PAT);
    }

    public static boolean isCHeaderFileName(String name) {
        return ProjectFileUtils.handleAll(name, DOT_H_PAT);
    }

    public static boolean isXmlFile(File file) {
        return ProjectFileUtils.handleFile(file, DOT_XML_PAT);
    }

    public static boolean isXmlFileName(String name) {
        return ProjectFileUtils.handleAll(name, DOT_XML_PAT);
    }

    public static boolean isCppHeaderFile(File file) {
        return ProjectFileUtils.handleFile(file, DOT_HPP_PAT);
    }

    public static boolean isCppHeaderFileName(String name) {
        return ProjectFileUtils.handleAll(name, DOT_HPP_PAT);
    }

    private static boolean handleAll(String filename, Pattern pattern) {
        if (filename == null) {
            return false;
        }
        return pattern.matcher(filename).matches();
    }

    private static boolean handleFile(File file, Pattern pattern) {
        if (file == null) {
            return false;
        }
        return ProjectFileUtils.handleAll(file.getName(), pattern);
    }
}

