/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.engine.BaseWrappedProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.model.MCustomization;
import com.silabs.ss.framework.project.api.core.model.MExclusion;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MInclusion;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelCompatibility;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ModuleProjectEngineOperationFactory
extends BaseWrappedProjectEngineOperationFactory
implements IProjectEngineOperationFactory {
    private MModule mmodule;
    private Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private ProjectModelCompatibility compat;

    public ModuleProjectEngineOperationFactory(IProjectEngineOperationFactory wrapped, IProjectModel model, MModule mmodule) {
        super(wrapped);
        this.mmodule = mmodule;
        this.compat = new ProjectModelCompatibility(model);
    }

    protected Pattern getPattern(String pattStr) {
        Pattern pattern = this.patternCache.get(pattStr);
        if (pattern == null || pattStr == null) {
            pattern = Pattern.compile(pattStr);
            this.patternCache.put(pattStr, pattern);
        }
        return pattern;
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFileOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFile, MFileEntry entry, MSelectable selector) throws IOException {
        ResourceInfo cust = this.applyCustomizations(session, projectPath);
        if (!cust.include) {
            return null;
        }
        if (cust.projectPath != null) {
            projectPath = cust.projectPath;
        }
        return super.createAddProjectFileOperation(session, containerFile, projectPath, contentFile, entry, selector);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFolderOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFolder, MFolderEntry entry, MSelectable selector) throws IOException {
        ResourceInfo cust = this.applyCustomizations(session, projectPath);
        if (!cust.include) {
            return null;
        }
        if (cust.projectPath != null) {
            projectPath = cust.projectPath;
        }
        return super.createAddProjectFolderOperation(session, containerFile, projectPath, contentFolder, entry, selector);
    }

    private ResourceInfo applyCustomizations(IProjectEngineSession session, IPath projectPath) {
        if (!this.mmodule.getCustomizationsGroup().isEmpty()) {
            boolean isFolder = projectPath.hasTrailingSeparator();
            boolean first = true;
            boolean included = true;
            for (MCustomization cust : this.mmodule.getCustomizations()) {
                String projectPathStr;
                Matcher m;
                Pattern p;
                List<IBuildConfigurationDescriptor> exclCfgs;
                if (first) {
                    if (!isFolder && cust instanceof MInclusion) {
                        included = false;
                    }
                    first = false;
                }
                if ((exclCfgs = this.compat.calculateContentExclusion(session.getProjectDescriptor(), (MSelectable)cust)) == null || (p = this.getPattern(cust.getPattern())) == null || !(m = p.matcher(projectPathStr = projectPath.makeRelative().toPortableString())).matches()) continue;
                if (cust instanceof MInclusion) {
                    included = true;
                    if (TextUtils.isEmpty((String)((MInclusion)cust).getReplacement())) continue;
                    projectPath = new Path(m.replaceAll(((MInclusion)cust).getReplacement()));
                    continue;
                }
                if (!(cust instanceof MExclusion)) continue;
                included = false;
            }
            if (!included) {
                return new ResourceInfo(false, projectPath);
            }
        }
        return new ResourceInfo(true, projectPath);
    }

    static class ResourceInfo {
        boolean include;
        IPath projectPath;

        public ResourceInfo(boolean include, IPath projectPath) {
            this.include = include;
            this.projectPath = projectPath;
        }
    }
}

