/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.ProjectVariables;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderReference;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectReference;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.api.core.model.MReference;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public final class ProjectModuleUpdateUtils {
    private static VariableSubstitutionEngine substEngine = new VariableSubstitutionEngine('(');

    static {
        substEngine.allowRecursion(true);
        substEngine.setOperatorHandler((IOperatorHandler)CoreOperatorHandler.INSTANCE);
    }

    private ProjectModuleUpdateUtils() {
    }

    public static void associateExistingEntriesWithModules(IProjectEntity project, MProject mproject, MProjectResourceTree resourceTree) {
        Collection projectModuleRefs = (Collection)project.getProperty(BuildConfigProperties.REFERENCED_MODULES);
        for (MConfiguration config : mproject.getConfigurations()) {
            IBuildConfiguration buildConf = project.findBuildConfiguration(config.getName());
            if (buildConf == null) continue;
            Collection configVisibleModuleRefs = (Collection)buildConf.getProperty(BuildConfigProperties.REFERENCED_MODULES);
            configVisibleModuleRefs.addAll(projectModuleRefs);
            MProjectReference cfgTree = (MProjectReference)resourceTree.getConfigurations().get((Object)config.getName());
            IVariableLookup variableLookup = ProjectVariables.createVariableLookup(buildConf);
            HashMap<String, MModule> moduleMap = new HashMap<String, MModule>();
            mproject.getModules().forEach(mod -> {
                MModule mModule = moduleMap.put(mod.getId(), (MModule)mod);
            });
            config.getModules().forEach(mod -> {
                MModule mModule = moduleMap.put(mod.getId(), (MModule)mod);
            });
            ProjectModuleUpdateUtils.associateExistingEntriesWithModules(variableLookup, cfgTree, moduleMap, configVisibleModuleRefs);
        }
    }

    private static void associateExistingEntriesWithModules(IVariableLookup variableLookup, MProjectReference ref, Map<String, MModule> moduleMap, Collection<IModuleReference> modRefs) {
        for (IModuleReference modRef : modRefs) {
            MModule addedModule = moduleMap.get(modRef.getId());
            if (addedModule == null) {
                addedModule = modRef.getModule();
            }
            for (String path : modRef.getBuiltinSources()) {
                Collection<MReference> pathRefs = ProjectModelUtils.findAllReferences((MFolderReference)ref, (IPath)new Path(substEngine.substitute(path, variableLookup)));
                for (MReference pathRef : pathRefs) {
                    if (modRef.isRemoved() && !ProjectModuleUpdateUtils.isExcludedEntry(pathRef)) continue;
                    pathRef.setProvidingModule(addedModule);
                    pathRef.setBuiltin(true);
                }
            }
        }
    }

    private static boolean isExcludedEntry(MReference ref) {
        if (ref instanceof MProjectReference || ref == null) {
            return false;
        }
        return ProjectModuleUpdateUtils.isExcludedEntry((MReference)ref.eContainer()) || ref.isExcluded();
    }

    public static void formatRawBuiltins(IProjectEntity project, MProject mproject, final MProjectResourceTree resourceTree) {
        new ProjectModelSwitchRecurser<Object>(){

            public Object caseMEntry(MEntry entry) {
                IPath prjPath = ProjectModelUtils.getProjectPathFor(entry);
                entry.setBuiltin(ProjectModuleUpdateUtils.isEntryBuiltin(resourceTree, prjPath));
                return null;
            }
        }.doSwitch((EObject)mproject);
    }

    public static IProjectModel convertRawToUserProject(IProjectModel project, IProjectEntity entity) {
        MProject mproject = project.getModel().copy();
        final Set<String> pdmBuildSteps = ProjectModuleUpdateUtils.pdmBuildSteps(mproject);
        new ProjectModelSwitchRecurser<Object>(){

            public Object caseMSettingsSite(MSettingsSite object) {
                object.getIncludePaths().removeIf(MSelectable::isBuiltin);
                object.getLibraryFiles().removeIf(MSelectable::isBuiltin);
                object.getLibraryPaths().removeIf(MSelectable::isBuiltin);
                object.getMacroDefinitions().removeIf(MSelectable::isBuiltin);
                object.getToolOptions().removeIf(MToolOption::calculateBuiltinState);
                return null;
            }

            public Object caseMConfigSettings(MConfigSettings settings) {
                if (pdmBuildSteps.contains(ProjectModuleUpdateUtils.buildStepId(settings.getPrebuildStep(), true))) {
                    settings.setPrebuildStep(null);
                }
                if (pdmBuildSteps.contains(ProjectModuleUpdateUtils.buildStepId(settings.getPostbuildStep(), false))) {
                    settings.setPostbuildStep(null);
                }
                return null;
            }

            protected boolean recursePdms() {
                return false;
            }
        }.doSwitch((EObject)mproject);
        Set<IModuleReference> allModuleRefs = ProjectModuleUpdateUtils.gatherExistingModuleReferences(entity);
        Collection existingProjectModules = (Collection)entity.getProperty(BuildConfigProperties.REFERENCED_MODULES);
        for (MConfiguration config : mproject.getConfigurations()) {
            IBuildConfiguration bconf = entity.findBuildConfiguration(config.getName());
            if (bconf == null) continue;
            ArrayList<IModuleReference> configModuleRefs = new ArrayList<IModuleReference>(existingProjectModules);
            configModuleRefs.addAll((Collection)bconf.getProperty(BuildConfigProperties.REFERENCED_MODULES));
            ProjectModuleUpdateUtils.removeBuiltinExcludes((MConfigSettings)config, configModuleRefs);
            IVariableLookup variableLookup = ProjectVariables.createVariableLookup(bconf);
            for (IModuleReference modRef : configModuleRefs) {
                if (modRef.getBuiltinSources().size() <= 0) continue;
                ProjectModuleUpdateUtils.recursivelyDeleteModuleSources(variableLookup, (MFolderEntry)mproject, "", modRef.getBuiltinSources(), mproject, project.getProjectResourceTree());
            }
        }
        ProjectModuleUpdateUtils.removeBuiltinExcludes((MConfigSettings)mproject, existingProjectModules);
        IVariableLookup variableLookup = ProjectVariables.createVariableLookup(entity);
        for (IModuleReference modRef : allModuleRefs) {
            ProjectModuleUpdateUtils.recursivelyDeleteModuleSources(variableLookup, (MFolderEntry)mproject, "", modRef.getBuiltinSources(), mproject, project.getProjectResourceTree());
        }
        IProjectModel model = IProjectModelEngineFactory.INSTANCE.createUserProjectModel(mproject, project);
        return model;
    }

    private static Set<String> pdmBuildSteps(MProject project) {
        return project.getProjectDefinedModules().stream().flatMap(pdm -> Stream.of(ProjectModuleUpdateUtils.buildStepId(pdm.getPrebuildStep(), true), ProjectModuleUpdateUtils.buildStepId(pdm.getPostbuildStep(), false))).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static String buildStepId(String buildCmd, boolean isPrebuild) {
        if (TextUtils.isEmpty((String)buildCmd)) {
            return null;
        }
        if (isPrebuild) {
            return "%PREBUILD%" + buildCmd;
        }
        return "%POSTBUILD%" + buildCmd;
    }

    public static Set<IModuleReference> gatherExistingModuleReferences(IProjectEntity entity) {
        HashSet<IModuleReference> existingModuleReferences = new HashSet<IModuleReference>();
        Collection existingProjectModules = (Collection)entity.getProperty(BuildConfigProperties.REFERENCED_MODULES);
        existingModuleReferences.addAll(existingProjectModules);
        IBuildConfiguration[] iBuildConfigurationArray = entity.getBuildConfigurations();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration bconf = iBuildConfigurationArray[n2];
            Collection existConfModules = (Collection)bconf.getProperty(BuildConfigProperties.REFERENCED_MODULES);
            existingModuleReferences.addAll(existConfModules);
            ++n2;
        }
        return existingModuleReferences;
    }

    private static void removeBuiltinExcludes(MConfigSettings config, Collection<IModuleReference> modProp) {
        for (IModuleReference modRef : modProp) {
            for (String exclPath : modRef.getBuiltinExcludes()) {
                config.getExcludedPaths().remove((Object)exclPath);
            }
        }
    }

    private static void recursivelyDeleteModuleSources(IVariableLookup variableLookup, MFolderEntry folder, String path, Collection<String> builtin, MProject project, MProjectResourceTree resourceTree) {
        ArrayList deleteFolders = new ArrayList();
        for (MFolderEntry fold : folder.getFolders()) {
            boolean hadContent = !fold.getFolders().isEmpty() || !fold.getFiles().isEmpty();
            String newPath = substEngine.substitute(path + fold.getName() + "/", variableLookup);
            ProjectModuleUpdateUtils.recursivelyDeleteModuleSources(variableLookup, fold, newPath, builtin, project, resourceTree);
            if (!hadContent || !fold.getFolders().isEmpty() || !fold.getFiles().isEmpty()) continue;
            ProjectModuleUpdateUtils.handleForSourceSettings(project, resourceTree, deleteFolders, fold);
        }
        folder.getFolders().removeAll(deleteFolders);
        ArrayList deleteFiles = new ArrayList();
        for (MFileEntry file : folder.getFiles()) {
            String filePath = substEngine.substitute(path + file.getName(), variableLookup);
            if (!builtin.contains(filePath)) continue;
            ProjectModuleUpdateUtils.handleForSourceSettings(project, resourceTree, deleteFiles, file);
        }
        folder.getFiles().removeAll(deleteFiles);
    }

    private static <T extends MEntry> void handleForSourceSettings(MProject project, MProjectResourceTree resourceTree, List<T> deleteFiles, T entry) {
        boolean canDelete;
        boolean isAllBuiltin = true;
        if (entry instanceof MFileEntry) {
            IPath prjPath = ProjectModelUtils.getProjectPathFor(entry);
            isAllBuiltin = ProjectModuleUpdateUtils.isEntryBuiltin(resourceTree, prjPath);
        }
        if ((canDelete = ProjectModuleUpdateUtils.canDeleteBuiltinEntry(project, entry)) && isAllBuiltin) {
            deleteFiles.add(entry);
        } else {
            entry.setBuiltin(isAllBuiltin);
        }
    }

    public static <T extends MEntry> boolean canDeleteBuiltinEntry(MProject project, T entry) {
        boolean anySourceSettings = Stream.concat(Stream.of(project), project.getConfigurations().stream()).map(MConfigSettings.class::cast).map(MConfigSettings::getEntrySettings).noneMatch(es -> es.containsKey((Object)entry));
        return anySourceSettings;
    }

    public static boolean isEntryBuiltin(MProjectResourceTree resourceTree, IPath prjPath) {
        boolean isAllBuiltin = resourceTree.getConfigurations().values().stream().map(pr -> ProjectModelUtils.findReference((MFolderReference)pr, prjPath)).filter(Objects::nonNull).allMatch(MReference::isBuiltin);
        return isAllBuiltin;
    }

    public static MProjectResourceTree createProjectResourceTree(MProject model, IVariableLookup variableLookup) {
        return ProjectModuleUpdateUtils.createProjectResourceTree(model, variableLookup, null);
    }

    public static MProjectResourceTree createProjectResourceTree(MProject model, IVariableLookup variableLookup, MProjectResourceTree userTree) {
        MProjectResourceTree resourceTree = ProjectModelFactory.eINSTANCE.createMProjectResourceTree();
        for (MConfiguration config : model.getConfigurations()) {
            boolean hasUserTree = userTree != null;
            MProjectReference userProj = userTree == null ? null : (MProjectReference)userTree.getConfigurations().get((Object)config.getName());
            MProjectReference configRsrcTree = ProjectModuleUpdateUtils.createConfigResourceTree(model, variableLookup, config, userProj, hasUserTree);
            resourceTree.getConfigurations().put((Object)config.getName(), (Object)configRsrcTree);
        }
        return resourceTree;
    }

    private static MProjectReference createConfigResourceTree(MProject model, IVariableLookup variableLookup, MConfiguration config, MProjectReference userTree, boolean hasUserTree) {
        MReference ref;
        MEntry ent;
        MProjectReference proj = ProjectModelFactory.eINSTANCE.createMProjectReference();
        proj.setRef((MFolderEntry)model);
        ProjectModuleUpdateUtils.populateReferenceTree((MFolderEntry)model, (MFolderReference)proj, proj.getEntryToReferenceMap(), userTree, hasUserTree);
        for (String excl : model.getExcludedPaths()) {
            ent = ProjectModelUtils.findEntry(variableLookup, (MFolderEntry)model, (IPath)new Path(excl));
            if (ent == null) continue;
            ref = (MReference)proj.getEntryToReferenceMap().get(ent);
            assert (ref != null);
            ref.setExcluded(true);
        }
        for (String excl : config.getExcludedPaths()) {
            ent = ProjectModelUtils.findEntry(variableLookup, (MFolderEntry)model, (IPath)new Path(excl));
            if (ent == null) continue;
            ref = (MReference)proj.getEntryToReferenceMap().get(ent);
            assert (ref != null);
            ref.setExcluded(true);
        }
        return proj;
    }

    private static void populateReferenceTree(MFolderEntry from, MFolderReference to, Map<MEntry, MReference> entToRef, MProjectReference userTree, boolean hasUserTree) {
        MFolderReference ref;
        for (MFolderEntry ent : from.getFolders()) {
            ref = ProjectModelFactory.eINSTANCE.createMFolderReference();
            ref.setRef(ent);
            ref.setBuiltin(ProjectModuleUpdateUtils.getBuiltinFlag(userTree, (MEntry)ent, hasUserTree));
            to.getFolders().add((Object)ref);
            entToRef.put((MEntry)ent, (MReference)ref);
            ProjectModuleUpdateUtils.populateReferenceTree(ent, ref, entToRef, userTree, hasUserTree);
        }
        for (MFolderEntry ent : from.getFiles()) {
            ref = ProjectModelFactory.eINSTANCE.createMFileReference();
            ref.setRef((MFileEntry)ent);
            ref.setBuiltin(ProjectModuleUpdateUtils.getBuiltinFlag(userTree, (MEntry)ent, hasUserTree));
            to.getFiles().add((Object)ref);
            entToRef.put((MEntry)ent, (MReference)ref);
        }
    }

    private static boolean getBuiltinFlag(MProjectReference userTree, MEntry entry, boolean hasUserTree) {
        if (!hasUserTree) {
            return entry.isBuiltin();
        }
        if (userTree == null) {
            return true;
        }
        IPath prjPath = ProjectModelUtils.getProjectPathFor(entry);
        MReference userRef = ProjectModelUtils.findReference((MFolderReference)userTree, prjPath);
        if (userRef == null) {
            return true;
        }
        return userRef.isBuiltin();
    }
}

