/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.entity;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.entity.BaseProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.BuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.entity.IProjectPathResolver;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class ExternalProjectEntity
extends BaseProjectEntity
implements IExternalProjectEntity {
    private final List<IBuildConfiguration> buildConfigs = new ArrayList<IBuildConfiguration>();
    private final IProjectType projType;
    private Map<File, String> fileContents;

    public ExternalProjectEntity(IProjectDescriptor desc, IProjectType projType) {
        super(desc, Activator.id());
        this.projType = projType;
        this.fileContents = new HashMap<File, String>();
        this.loadBuildConfigs();
    }

    private void loadBuildConfigs() {
        IBuildConfigurationDescriptor[] iBuildConfigurationDescriptorArray = ((IProjectDescriptor)this.getDescriptor()).getBuildConfigurationDescriptors();
        int n = iBuildConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigurationDescriptor bConf = iBuildConfigurationDescriptorArray[n2];
            this.buildConfigs.add(this.createBuildConfig(bConf));
            ++n2;
        }
    }

    private BuildConfiguration createBuildConfig(IBuildConfigurationDescriptor bConf) {
        return new BuildConfiguration(this, bConf);
    }

    @Override
    public IPath getProjectPath() {
        IPath path;
        IProjectPathResolver resolver = (IProjectPathResolver)this.getProjectType().getAdapter(IProjectPathResolver.class);
        if (resolver != null && (path = resolver.resolveProjectPath((IDescriptor)this)) != null && IPathUtils.empty() != path) {
            return path;
        }
        try {
            path = super.getInstallationPath();
            if (Path.EMPTY == path) {
                path = ((IProjectDescriptor)this.getDescriptor()).getInstallationPath();
            }
            return path.removeLastSegments(1);
        }
        catch (IOException iOException) {
            return Path.EMPTY;
        }
    }

    @Override
    public IProjectType getProjectType() {
        return this.projType;
    }

    @Override
    public IBuildConfiguration[] getBuildConfigurations() {
        return (IBuildConfiguration[])this.buildConfigs.toArray(IBuildConfiguration[]::new);
    }

    @Override
    public void setCurrentConfiguration(IBuildConfiguration config) throws CoreException {
        ((IWriteableProjectDescriptor)this.getDescriptor()).setCurrentConfigurationDescriptor((IBuildConfigurationDescriptor)config.getDescriptor());
    }

    @Override
    public IBuildConfiguration getCurrentConfiguration() {
        return this.findForDescriptor(((IProjectDescriptor)this.getDescriptor()).getCurrentConfigurationDescriptor());
    }

    @Override
    public IBuildConfiguration findBuildConfiguration(String id) {
        return this.findForDescriptor(((IProjectDescriptor)this.getDescriptor()).findBuildConfigurationDescriptor(id));
    }

    @Override
    public IBuildConfiguration findBuildConfigurationByLabel(String label) {
        for (IBuildConfiguration buildConfig : this.buildConfigs) {
            if (!Objects.equals(label, buildConfig.getLabel())) continue;
            return buildConfig;
        }
        return null;
    }

    private IBuildConfiguration findForDescriptor(IBuildConfigurationDescriptor desc) {
        for (IBuildConfiguration buildConfig : this.buildConfigs) {
            if (!Objects.equals(buildConfig.getDescriptor(), desc)) continue;
            return buildConfig;
        }
        return null;
    }

    @Override
    public IBuildConfiguration addBuildConfiguration(IBuildConfigurationDescriptor data) {
        if (((IProjectDescriptor)this.getDescriptor()).findBuildConfigurationDescriptor(data.getId()) == null) {
            ((IWriteableProjectDescriptor)this.getDescriptor()).buildConfigurationDescriptors().add(data);
        }
        BuildConfiguration bconf = this.createBuildConfig(data);
        this.buildConfigs.add(bconf);
        return bconf;
    }

    @Override
    public void removeBuildConfiguration(IBuildConfiguration config) throws CoreException {
        this.buildConfigs.remove(config);
    }

    protected String getDefaultPropertyScope() {
        return "project";
    }

    @Override
    public File getInstallationFile() {
        try {
            return super.getInstallationPath().toFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFileContents() {
        return this.getFileContents(this.getInstallationFile());
    }

    @Override
    public String getFileContents(File file) {
        String content = this.fileContents.get(file);
        if (content == null) {
            content = this.loadFileFromDisk(file);
        }
        return content;
    }

    private String loadFileFromDisk(File file) {
        if (file == null || !file.isFile()) {
            return "";
        }
        try {
            return new String(FileUtils.readFileContents((File)file, null));
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
            return "";
        }
    }

    @Override
    public void setFileContents(File file, String newContents) {
        if (newContents != null) {
            this.fileContents.put(file, newContents);
        }
    }

    @Override
    public void revert() throws CoreException {
        this.loadFileFromDisk(this.getInstallationFile());
    }

    @Override
    public void save(MultiStatus status, IProgressMonitor monitor) throws CoreException {
        Map<File, String> localContents = this.fileContents;
        this.fileContents = new HashMap<File, String>();
        for (Map.Entry<File, String> entry : localContents.entrySet()) {
            try {
                File key = entry.getKey();
                key.getParentFile().mkdirs();
                FileUtils.writeFileContents((File)entry.getKey(), (String)entry.getValue());
            }
            catch (IOException e) {
                status.add(Activator.reporter.newErrorStatus("Failed to save file", (Throwable)e));
            }
        }
    }

    @Override
    public void setConfigurationDirty(IBuildConfiguration config, boolean dirty) {
    }

    @Override
    public void edit() throws CoreException {
    }

    @Override
    public void editMetadata() throws CoreException {
    }

    @Override
    public void setup(IProjectModel projectModel, IProgressMonitor monitor) throws CoreException {
        if (this.getBuildConfigurations().length == 0) {
            List<IBuildConfigurationDescriptor> bConfs;
            if (projectModel.getModel().getConfigurations().size() > 0) {
                bConfs = projectModel.getModel().getConfigurations().stream().map(this::loadBuildConfig).collect(Collectors.toList());
            } else {
                IBuildConfigurationDescriptor bConfDesc = this.getProjectType().createBuildConfigurationDescriptor((IProjectDescriptor)this.getDescriptor());
                bConfDesc.setName("Default");
                bConfs = Arrays.asList(bConfDesc);
            }
            ((IWriteableProjectDescriptor)this.getDescriptor()).setBuildConfigurationDescriptors(bConfs);
            bConfs.stream().forEachOrdered(this::addBuildConfiguration);
        }
    }

    private IBuildConfigurationDescriptor loadBuildConfig(MConfiguration config) {
        IBuildConfigurationDescriptor bConfDesc = this.getProjectType().createBuildConfigurationDescriptor((IProjectDescriptor)this.getDescriptor());
        bConfDesc.applySettings(config);
        return bConfDesc;
    }
}

