/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.external.options;

import com.silabs.ss.framework.project.api.core.external.options.GenericAssemblerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCLinkerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCppCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCppLinkerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericToolchainOptions;
import com.silabs.ss.framework.project.api.core.model.options.GenericBuildOptions;
import com.silabs.ss.framework.project.api.core.model.options.IGenericBuildOptionsProvider;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class BuiltinGenericBuildOptionsProvider
implements IGenericBuildOptionsProvider {
    public void registerGroups() {
        this.register(GenericToolchainOptions.class);
        this.register(GenericCCompilerOptions.class);
        this.register(GenericCppCompilerOptions.class);
        this.register(GenericCLinkerOptions.class);
        this.register(GenericCppLinkerOptions.class);
        this.register(GenericAssemblerOptions.class);
    }

    public void removeGroups() {
        this.remove(GenericToolchainOptions.class);
        this.remove(GenericCCompilerOptions.class);
        this.register(GenericCppCompilerOptions.class);
        this.remove(GenericCLinkerOptions.class);
        this.remove(GenericCppLinkerOptions.class);
        this.remove(GenericAssemblerOptions.class);
    }

    private void register(Class<?> klass) {
        AnnotatedElement[] annotatedElementArray = klass.getFields();
        int n = annotatedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = annotatedElementArray[n2];
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                try {
                    if (field.getType().equals(IPropertyGroup.class)) {
                        IPropertyGroup group = (IPropertyGroup)field.get(null);
                        GenericBuildOptions.registry().registerOptionGroup(group.getId());
                    } else if (field.getType().equals(IProperty.class)) {
                        field.get(null);
                    }
                }
                catch (Exception e) {
                    Activator.reporter.logError("failed to register option or group from " + String.valueOf(field), (Throwable)e);
                }
            }
            ++n2;
        }
        annotatedElementArray = klass.getClasses();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement subKlass = annotatedElementArray[n2];
            this.register((Class<?>)subKlass);
            ++n2;
        }
    }

    private void remove(Class<?> klass) {
        AnnotatedElement[] annotatedElementArray = klass.getFields();
        int n = annotatedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = annotatedElementArray[n2];
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                try {
                    if (field.getType().equals(IPropertyGroup.class)) {
                        IPropertyGroup group = (IPropertyGroup)field.get(null);
                        GenericBuildOptions.registry().removeOptionGroup(group.getId());
                        Property.registry().removePropertyGroup(group);
                    } else if (field.getType().equals(IProperty.class)) {
                        IProperty prop = (IProperty)field.get(null);
                        Property.registry().removeDescriptor((IDescriptor)prop);
                    }
                }
                catch (Exception e) {
                    Activator.reporter.logError("failed to remove option or group from " + String.valueOf(field), (Throwable)e);
                }
            }
            ++n2;
        }
        annotatedElementArray = klass.getClasses();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement subKlass = annotatedElementArray[n2];
            this.remove((Class<?>)subKlass);
            ++n2;
        }
    }
}

