/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.toolsinfo;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPack;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackAction;
import com.silabs.ss.platform.api.apack.core.model.IPlatformSpecific;
import com.silabs.ss.platform.api.apack.core.model.external.Executable;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.BaseToolInfoResolver;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.IToolInfoResolver;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.IToolInfoResolverProvider;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.model.ToolInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApackToolInfoResolverProvider
implements IToolInfoResolverProvider {
    public Collection<IToolInfoResolver> resolvers() {
        LinkedHashMap resolverMap = Stream.of(AdapterPackManager.instance().adapterPacks()).map(IAdapterPack::actions).flatMap(iAdapterPackActionArray -> Stream.of(iAdapterPackActionArray)).map(arg_0 -> ((Caster)Caster.with(Executable.class)).cast(arg_0)).filter(Objects::nonNull).filter(IPlatformSpecific::isLocalPlatform).filter(e -> e.executableFile().isFile()).collect(Collectors.toMap(IAdapterPackAction::id, this::resolverFor, (p, q) -> p, LinkedHashMap::new));
        return resolverMap.values();
    }

    private IToolInfoResolver resolverFor(Executable exe) {
        return new ApackToolInfoResolver(exe);
    }

    public static class ApackToolInfoResolver
    extends BaseToolInfoResolver
    implements IToolInfoResolver {
        private IAdapterPack apack;
        private Executable exe;

        private ApackToolInfoResolver(Executable exe) {
            super(exe.id());
            this.apack = exe.adapterPack();
            this.exe = exe;
        }

        public Collection<ToolInfo> resolve() {
            return List.of(this.createInfo(this.exe.executableFile().getAbsolutePath(), this.resolveVersion()));
        }

        protected String resolveVersion() {
            String version = this.apack.value("version");
            return TextUtils.hasContent((String)version) ? version : "0.0.0";
        }
    }
}

