/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExternalOptionsUtils {
    public static final PropertyReference<Collection<String>> LANGUAGE_TYPE = CoreTypes.STRING_LIST.property("languageType");

    protected static IPropertyGroup registerGroup(String id, String label, String description, ELanguage ... langs) {
        IPropertyGroup group = Property.registry().registerPropertyGroup(id, label, description);
        ((IWriteableDescriptor)group).setProperty(LANGUAGE_TYPE, (Object)Stream.of(langs).map(String::valueOf).collect(Collectors.toList()));
        return group;
    }

    protected static IProperty stringProperty(IPropertyGroup group, String name, String description, ELanguage ... langs) {
        IProperty prop = Property.registry().registerProperty(group, name, "string", description);
        if (langs.length > 0) {
            ((IWriteableDescriptor)prop).setProperty(LANGUAGE_TYPE, (Object)Stream.of(langs).map(String::valueOf).collect(Collectors.toList()));
        }
        return prop;
    }

    protected static IProperty stringListProperty(IPropertyGroup group, String name, String description) {
        return Property.registry().registerProperty(group, name, "stringList", description);
    }
}

