/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.google.common.collect.ImmutableMap;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.engine.IVariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.IToolchainLocations;
import com.silabs.ss.framework.project.api.core.engine.StudioURLConverter;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.toolchain.core.IResolvedToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.ToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableVersionedDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public final class StudioExporterUtils {
    public static Path loadFromVariables(IVariableStore projectVariables, String variableName) {
        String path = (String)projectVariables.getValue(variableName);
        if (path != null) {
            try {
                path = URIUtils.toFileWithRelative((URI)URI.create(path)).toString();
            }
            catch (IOException e) {
                Activator.reporter.logException((Throwable)e);
            }
            return Paths.get(path, new String[0]);
        }
        return null;
    }

    public static IProperty findProperty(AddToolOptionOperation operation) {
        return StudioExporterUtils.findProperty(operation.getToolId(), operation.getOptionId());
    }

    public static IProperty findProperty(String toolId, String optionId) {
        IProperty prop = Property.registry().findProperty(optionId);
        if (prop == null) {
            IPropertyGroup group = Property.registry().findPropertyGroup(toolId);
            if (group == null) {
                return null;
            }
            prop = group.findProperty(optionId);
        }
        return prop;
    }

    public static IResolvedToolOption getToolOption(AddToolOptionOperation op, IProperty prop, boolean isListValue, Collection<String> values) {
        boolean updateValueBase = false;
        String value = op.getValue();
        String[] listValues = op.getListValues();
        if (isListValue && op.getValue() != null) {
            listValues = (String[])values.toArray(String[]::new);
            value = null;
            updateValueBase = true;
        }
        ToolOption option = new ToolOption(op.getToolId(), prop.getId(), value, listValues);
        option.setBuiltin(op.isBuiltin());
        if (updateValueBase) {
            option.setListValueBuiltin(op.getValue(), op.isBuiltin());
        }
        op.getListOperatons().forEach(o -> option.setListValueBuiltin(o.getValue(), o.isBuiltin()));
        return option;
    }

    public static String resolveAndRelativizePath(IVariableSubstitutionEngine engine, IVariableStore variables, URI uri, boolean allowAbsolute, Path ... relativeDirs) {
        File fileLoc = StudioExporterUtils.resolvePath(engine, variables, uri);
        return StudioExporterUtils.getRelativePath(fileLoc, allowAbsolute, relativeDirs);
    }

    public static File resolvePath(IVariableSubstitutionEngine engine, IVariableStore variables, URI uri) {
        File fileLoc = null;
        URI newURI = uri;
        if ("studio".equals(uri.getScheme())) {
            String uriStr = StudioURLConverter.convertToVariable(uri.toString());
            String subStr = engine.substitute(uriStr, (IVariableLookup)variables);
            try {
                newURI = URI.create(subStr);
                fileLoc = URIUtils.resolveURIToPath((URI)newURI).toFile();
            }
            catch (IOException | IllegalArgumentException exception) {
                fileLoc = new File(subStr);
            }
        } else {
            try {
                fileLoc = URIUtils.toFileWithRelative((URI)newURI);
            }
            catch (IOException | IllegalArgumentException exception) {
                fileLoc = new File(uri);
            }
        }
        return fileLoc;
    }

    public static String getRelativePath(File fileLoc, boolean allowAbsolute, Path ... relativeDirs) {
        Path filePath = fileLoc.toPath();
        String bestPath = allowAbsolute ? filePath.toString() : null;
        int i = 0;
        while (i < relativeDirs.length) {
            Path relativeDir = relativeDirs[i];
            if (relativeDir != null) {
                String varCounter = StudioExporterUtils.getVariableCounter(i);
                Optional<String> relativizedOpt = Optional.ofNullable(relativeDir).map(g -> StudioExporterUtils.doRelativize(g, filePath)).map(p -> varCounter + p);
                if (relativizedOpt.isPresent()) {
                    String relativized = relativizedOpt.get();
                    if (bestPath == null || relativized.length() < bestPath.length()) {
                        bestPath = relativized;
                    }
                }
            }
            ++i;
        }
        if (bestPath == null) {
            return filePath.toString();
        }
        return bestPath;
    }

    public static String getVariableCounter(int count) {
        return "$" + count + "$";
    }

    private static String doRelativize(Path basePath, Path filePath) {
        Optional<String> relPath = FileUtils.tryRelativise((Path)basePath, (Path)filePath).map(Object::toString);
        if (relPath.isEmpty()) {
            return filePath.isAbsolute() ? null : filePath.toString();
        }
        return relPath.filter(TextUtils::hasContent).orElse(".");
    }

    public static IToolchainDescriptor findToolchain(IProjectEntity entity) {
        String toolchainId;
        ImmutableMap<String, URI> toolchainMapping;
        URI foundLocation;
        if (entity == null) {
            return null;
        }
        IToolchainLocations toolchainLocations = (IToolchainLocations)entity.getProperty(ProjectCommonProperties.TOOLCHAIN_LOCATIONS);
        if (toolchainLocations.use() && (foundLocation = (URI)(toolchainMapping = toolchainLocations.toolchainLocations()).get((Object)(toolchainId = (String)((Collection)entity.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY)).stream().findFirst().orElse(null)))) != null) {
            return StudioExporterUtils.createSessionToolchainDescriptor(toolchainId, foundLocation);
        }
        IToolchainDescriptor toolchain = (IToolchainDescriptor)Toolchain.manager().findDescriptor((String)entity.getProperty(ProjectProperties.TOOLCHAIN_ID));
        if (StudioExporterUtils.isEmptyToolchain(toolchain) && StudioExporterUtils.isEmptyToolchain(toolchain = (IToolchainDescriptor)((Collection)entity.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY)).stream().map(ToolchainUtils::findCliToolchain).filter(Objects::nonNull).findFirst().orElse(null))) {
            IToolchainDescriptor[] toolchains = (IToolchainDescriptor[])Compatibility.fromGrammar((IRegistry)Toolchain.manager(), (Collection)((Collection)entity.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY))).getCompatibleDescriptors((IRegistry)Toolchain.manager());
            toolchain = DescriptorUtils.sortByBestDescriptor((IDescriptor[])toolchains, null, null, (boolean)true).stream().filter(Objects::nonNull).findFirst().orElse(null);
        }
        return toolchain;
    }

    private static IToolchainDescriptor createSessionToolchainDescriptor(String toolchainId, URI toolchainInstallationLocation) {
        IToolchainDescriptor newToolchain = (IToolchainDescriptor)Toolchain.manager().createDescriptor();
        IWriteableVersionedDescriptor writer = (IWriteableVersionedDescriptor)newToolchain;
        writer.setUnversionedId("session-custom." + toolchainId);
        writer.setProperty(CoreProperties.INSTALLATION_PATH.id(), (Object)toolchainInstallationLocation);
        return newToolchain;
    }

    public static boolean isEmptyToolchain(IToolchainDescriptor toolchain) {
        return toolchain == null || "com.silabs.ss.framework.project.core.noToolChain:0.0.0".equals(toolchain.getId());
    }
}

