/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadata;
import com.silabs.ss.platform.api.idemanager.core.AbstractIDE;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import com.silabs.ss.platform.api.idemanager.core.IIDE2;
import com.silabs.ss.platform.api.idemanager.core.IIDELauncher;
import com.silabs.ss.platform.api.idemanager.core.IIDESelection;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class GenericIDE
extends AbstractIDE
implements IIDESelection,
IIDE2 {
    private static final String IDE_LAUNCHER_EXTENSION_POINT = "com.silabs.ss.platform.idelauncher";
    private final IDEMetadata metadata;
    private String partCompatibility;
    private String name;
    private String description;
    private List<String> projectFileExtensions;
    private String ideCompatibility;
    private String exportProjectTypeId;
    private IIDELauncher launcher;

    public GenericIDE(IDEMetadata metadata, String name, String ideCompatibility, String version, String description, IPath exePath, String partCompatibility, List<String> projectFileExtensions, String exportProjectTypeId, String launcherId) {
        super(version, exePath);
        this.metadata = metadata;
        this.name = name;
        this.description = description;
        this.partCompatibility = partCompatibility;
        this.projectFileExtensions = projectFileExtensions;
        this.ideCompatibility = ideCompatibility;
        this.exportProjectTypeId = exportProjectTypeId;
        if (!TextUtils.isEmpty((String)launcherId)) {
            this.launcher = this.getLauncher(launcherId);
        }
    }

    public IDEMetadata ideMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPartCompatibility() {
        return this.partCompatibility;
    }

    public String getExportProjectTypeId() {
        return this.exportProjectTypeId;
    }

    public String[] getProjectFileExtensions() {
        return this.projectFileExtensions.toArray(new String[0]);
    }

    public String getIdeCompatibilityId() {
        return this.ideCompatibility;
    }

    public IIDE[] getAvailableIDEs() {
        return new IIDE[]{this};
    }

    public void launch(boolean launchNew, File toOpen) throws CoreException {
        if (this.launcher != null) {
            this.launcher.launchWithArgs(toOpen, Collections.emptyMap());
        } else {
            super.launch(launchNew, toOpen);
        }
    }

    private IIDELauncher getLauncher(String launcherName) {
        IIDELauncher launcher = null;
        try {
            IConfigurationElement[] configElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(IDE_LAUNCHER_EXTENSION_POINT);
            IConfigurationElement launcherElement = Stream.of(configElementArray).filter(element -> element.getAttribute("name").equalsIgnoreCase(launcherName)).findFirst().orElse(null);
            if (launcherElement != null) {
                launcher = (IIDELauncher)launcherElement.createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            Activator.reporter.logError("Error during processing IDE launcher.", (Throwable)e);
        }
        return launcher;
    }
}

