/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericIDE;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericIDEFactory;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericProjectTypeFactory;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadata;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadataLoader;
import com.silabs.ss.platform.api.idemanager.core.AbstractIDEProvider;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import com.silabs.ss.platform.api.idemanager.core.IIDEProvider;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;

public class GenericIDEProvider
extends AbstractIDEProvider
implements IIDEProvider {
    private boolean defaultLoaded = false;
    private Map<String, GenericIDE> ideMap = new ConcurrentHashMap<String, GenericIDE>();

    public IIDE detectIDE(IPath path) {
        return null;
    }

    protected void detectIDE() {
        try {
            if (!this.defaultLoaded) {
                this.defaultLoaded = true;
                File externalFolder = IDEMetadataLoader.instance().copyInternalFilesToExternalFilesLocation();
                this.detectIDEs(IDEMetadataLoader.instance().internalFiles());
                this.detectIDEs(externalFolder);
            }
        }
        catch (Exception e) {
            this.defaultLoaded = false;
            Activator.reporter.logError("Error copying IDE Metadata file templates to external location", (Throwable)e);
        }
    }

    public void detectIDEs(File externalIdeFolder) {
        List<IDEMetadata> idesFromMetadata = IDEMetadataLoader.instance().loadFiles(externalIdeFolder);
        List<GenericIDE> ideList = GenericIDEFactory.create(idesFromMetadata);
        long newIdeCount = ideList.stream().filter(i -> this.ideMap.putIfAbsent(i.getID(), (GenericIDE)((Object)i)) == null).map(this::registerIde).count();
        if (newIdeCount > 0L) {
            IDEPreferenceManager.reloadIDEs();
        }
    }

    private IIDE registerIde(GenericIDE ide) {
        this.ides.add(ide);
        IProjectType pt = GenericProjectTypeFactory.instance().createProjectType(ide.ideMetadata());
        ProjectType.manager().registerProjectType(pt);
        IExternalType et = GenericProjectTypeFactory.instance().createExternalType(ide.ideMetadata());
        ProjectType.manager().registerExternalType(et);
        return ide;
    }
}

