/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.MapUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.ThrowableFunction;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.KeyedVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.IVariableSubstitutionEngine;
import com.silabs.java.utils.variables.engine.StockVariables;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.engine.BaseExternalProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.AddIncludePathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryFileSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryPathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddMacroDefinitionSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectResourceFilterOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddSourceFolderToConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFileProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectLanguageSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IncludeResourceIntoConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ResetModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationOutputBaseNameOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPrebuildStepOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.property.DefineUtils;
import com.silabs.ss.framework.project.api.core.utils.ProjectFileUtils;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGenerator;
import com.silabs.ss.framework.project.api.generator.template.TemplateContribution;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalOptionsUtils;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTemplates;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTypeUtils;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericIDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.NonTemplateFileContext;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileJinjaOptions;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileExternalOptions;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenericOperationHandler
extends BaseExternalProjectEngineOperationHandler {
    public static final String POST_BUILD_VAR = "$(POST_BUILD_EXE)";
    protected Map<String, Object> projectContentMap;
    protected List<File> templateFiles;
    protected Set<String> basePropertyIds;
    protected IVariableSubstitutionEngine standardEngine = VariableSubstitutionEngine.create((char)'(', (IOperatorHandler)CoreOperatorHandler.INSTANCE, (boolean)false);
    protected IVariableStore projectVariables;
    protected Path generationDir;
    protected Path pkgPath;
    protected Path sdkDir;
    protected Path copiedSdkDir;
    protected GenericMetadataHandler metadata;
    protected GenericTemplates allTemplates;
    private IGenericIDETemplate templates;
    private List<IDEGenerator> nonTemplateGeneratorList;
    private NonTemplateFileContext context;
    private Collection<AddFileOp> addedFiles;
    private Set<IPath> excludedPaths;

    public GenericOperationHandler(IExternalProjectEntity projEntity, GenericTemplates templates, List<IDEGenerator> nonTemplateGeneratorList) {
        super(projEntity);
        this.allTemplates = templates;
        this.nonTemplateGeneratorList = nonTemplateGeneratorList;
        this.context = new NonTemplateFileContext(projEntity);
    }

    @Override
    public void load() throws CoreException {
        IBuildConfiguration bConf = this.getProjectEntity().getCurrentConfiguration();
        if (bConf == null && this.getProjectEntity().getBuildConfigurations().length == 0) {
            throw new IllegalStateException("Input project does not have configurations set!");
        }
        bConf = this.getProjectEntity().getBuildConfigurations()[0];
        this.projectContentMap = new HashMap<String, Object>();
        this.addedFiles = new ArrayList<AddFileOp>();
        this.excludedPaths = new HashSet<IPath>();
        File templateFile = null;
        try {
            templateFile = this.getProjectEntity().getInstallationPath().toFile();
        }
        catch (IOException iOException) {}
        this.metadata = this.createMetadataHandler(templateFile);
        this.metadata.modules().resetPdms();
        this.metadata.projectContent().clearContent();
        this.metadata.projectContent().addConfiguration(bConf);
        this.metadata.properties().add(bConf);
        this.projectVariables = new KeyedVariableLookup();
        StockVariables.INSTANCE.setVariables(this.projectVariables, (Object)bConf);
        this.setUpTemplateFilesAndProperties();
        this.projectVariables.setValue("PROJECT_NAME", (Object)this.getProjectEntity().getName());
        this.generationDir = this.getProjectEntity().getProjectPath().toFile().toPath();
        this.projectVariables.setValue("projectLocation", (Object)this.generationDir);
        this.metadata.projectRoot.registerRoot(templateFile.toPath(), this.generationDir);
        this.projectContentMap.put(MakefileJinjaOptions.ProjectOptions.PROJECT_NAME.name(), this.getProjectEntity().getName());
        MakefileJinjaOptions.setupToolsInfoData(this.getProjectEntity(), this.projectContentMap);
        this.sdkDir = this.loadPath("sdkInstallationPath", MakefileJinjaOptions.ProjectOptions.SDK_PATH, true, (ThrowableFunction<String, Object, IOException>)((ThrowableFunction)sdkPath -> URIUtils.toFileWithRelative((URI)URI.create(sdkPath))));
        this.copiedSdkDir = this.loadPath("copiedSdkLocation", MakefileJinjaOptions.ProjectOptions.COPIED_SDK_PATH, false, (ThrowableFunction<String, Object, IOException>)((ThrowableFunction)sdkPath -> this.generationDir.resolve((String)sdkPath)));
        this.pkgPath = this.loadPath("pkgInstallPath", MakefileJinjaOptions.ProjectOptions.PKG_PATH, true, (ThrowableFunction<String, Object, IOException>)((ThrowableFunction)sdkPath -> URIUtils.toFileWithRelative((URI)URI.create(sdkPath))));
        this.projectContentMap.put(MakefileJinjaOptions.ProjectOptions.PROJECT_PATH.name(), "");
        try {
            if (TextUtils.hasContent((String)this.generationDir.toString().trim())) {
                this.projectContentMap.put(MakefileJinjaOptions.ProjectOptions.PROJECT_PATH.name(), this.generationDir.toString().trim());
            }
        }
        catch (Exception exception) {}
    }

    private Path loadPath(String variable, MakefileJinjaOptions.ProjectOptions projOpt, boolean isAbsolute, ThrowableFunction<String, Object, IOException> resolver) {
        String pathVariable = (String)this.projectVariables.getValue(variable);
        if (pathVariable == null) {
            return null;
        }
        String pathStr = pathVariable;
        try {
            pathStr = resolver.apply((Object)pathStr).toString();
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
        this.projectContentMap.put(projOpt.name(), isAbsolute ? pathStr : pathVariable);
        Path realPath = Paths.get(pathStr, new String[0]);
        try {
            realPath = realPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {}
        return realPath;
    }

    protected void setUpTemplateFilesAndProperties() throws CoreException {
        try {
            this.templates = (IGenericIDETemplate)this.allTemplates.getIDETemplate((IDescriptor)this.getProjectEntity());
            this.templateFiles = this.allTemplates.getTemplates(this.getProjectEntity(), this.templates);
            this.basePropertyIds = this.allTemplates.getBasePropertyIds((IDescriptor)this.getProjectEntity());
        }
        catch (IOException e1) {
            throw Activator.reporter.newCoreException("Failed to load templates for " + this.getProjectEntity().getLabel() + ". Cannot export to project file!", (Throwable)e1);
        }
    }

    protected GenericMetadataHandler createMetadataHandler(File templateFile) throws CoreException {
        return GenericMetadataHandler.forWriting(this.projectContentMap, templateFile);
    }

    @Override
    public void commit() throws CoreException {
        try {
            this.handleFileRegistration();
            ITemplateGenerator generator = this.createGenerator();
            this.metadata.write();
            this.populateGeneratorWithjinjaOptions(generator);
            IPath basePath = this.getBasePath();
            this.generateOutputFromTemplateFiles(generator, basePath);
            GenericTypeUtils.generateOutputWithGenerators(this.nonTemplateGeneratorList, this.context);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to generate output file!", (Throwable)e);
        }
    }

    protected ITemplateGenerator createGenerator() throws CoreException {
        return GenericTypeUtils.createGenerator(this.templateFiles);
    }

    protected void populateGeneratorWithjinjaOptions(ITemplateGenerator generator) {
        MakefileJinjaOptions.allProjectOptions().map(n -> new TemplateContribution(n.name(), this.projectContentMap.computeIfAbsent(n.name(), s -> n.defaultObj().get()), 0)).forEachOrdered(arg_0 -> ((ITemplateGenerator)generator).add(arg_0));
    }

    protected IPath getBasePath() throws IOException {
        if (this.templates != null) {
            return IPathUtils.create((String)this.generationDir.toFile().getAbsolutePath());
        }
        return this.getProjectEntity().getInstallationPath().removeFileExtension();
    }

    protected void generateOutputFromTemplateFiles(ITemplateGenerator generator, IPath basePath) throws IOException {
        for (File template : this.templateFiles) {
            File outputFile = this.getNewFile(basePath, template, generator);
            GenericTypeUtils.generateOutputFromTemplateFiles(this.templates, template, generator, outputFile);
        }
    }

    protected File generateOutput(ITemplateGenerator generator, IPath basePath, File aTemplate, boolean overwrite) throws IOException {
        File newFile = this.getNewFile(basePath, aTemplate, generator);
        return this.generateOutput(generator, aTemplate, newFile, overwrite);
    }

    protected File generateOutput(ITemplateGenerator generator, File templateFile, File outputFile, boolean overwrite) throws IOException {
        return GenericTypeUtils.generateOutput(generator, templateFile, outputFile, overwrite);
    }

    protected File getNewFile(IPath basePath, File templateFile) {
        return this.getNewFile(basePath, templateFile, null);
    }

    @Override
    protected File getOutputDirectory() {
        return this.generationDir.toFile();
    }

    protected File getNewFile(IPath basePath, File templateFile, ITemplateGenerator generator) {
        File file = Optional.ofNullable(this.templates).flatMap(t -> t.getTargetPath(templateFile, (IVariableLookup)this.projectVariables)).map(path -> new File(basePath.toFile(), (String)path)).orElse(null);
        if (file != null) {
            return file;
        }
        return null;
    }

    @Override
    protected void handleAddCopiedFileReference(ICopiedFileReference reference) {
        this.metadata.copiedFiles().add(reference);
    }

    @Override
    protected Collection<ICopiedFileReference> copiedFiles() {
        return this.metadata.copiedFiles().copiedFileRefs();
    }

    @Override
    public void handleSetConfigurationPrebuildStepOperation(SetConfigurationPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        String preBuild = this.substitutePostBuildVariables(operation.getPrebuildStep());
        this.projectContentMap.put(MakefileJinjaOptions.PostBuildToolOpts.PRE_BUILD_ARGS.name(), preBuild);
    }

    @Override
    public void handleSetConfigurationPostbuildStepOperation(SetConfigurationPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        String postBuild = this.substitutePostBuildVariables(operation.getPostbuildStep());
        this.projectContentMap.put(MakefileJinjaOptions.PostBuildToolOpts.POST_BUILD_ARGS.name(), postBuild);
    }

    @Override
    public String lookupCommanderVariable() {
        return POST_BUILD_VAR;
    }

    @Override
    protected String lookupBuildDirVariable() {
        return "$(OUTPUT_DIR)";
    }

    @Override
    public void handleAddToolOptionOperation(AddToolOptionOperation op, IProgressMonitor monitor) throws CoreException {
        IProperty prop;
        block4: {
            block3: {
                prop = StudioExporterUtils.findProperty(op);
                if (prop == null) break block3;
                if (!this.basePropertyIds.stream().noneMatch(prop.getId()::startsWith)) break block4;
            }
            return;
        }
        Collection<Object> baseValues = !TextUtils.isEmpty((String)op.getValue()) ? Arrays.asList(op.getValue()) : (Collection)op.getListOperatons().stream().map(AddToolOptionOperation.AddToolListOptionOperation::getValue).collect(Collectors.toList());
        Collection types = ((Collection)prop.getProperty(ExternalOptionsUtils.LANGUAGE_TYPE)).stream().map(ELanguage::get).collect(Collectors.toSet());
        for (Object baseValue : baseValues) {
            String outputValue = MakefileExternalOptions.convertToValue(prop, baseValue);
            this.handleLanguageContent(types, MakefileJinjaOptions.ProjectOptions.EXT_ASM_FLAGS, MakefileJinjaOptions.ProjectOptions.EXT_CFLAGS, MakefileJinjaOptions.ProjectOptions.EXT_CXX_FLAGS, MakefileJinjaOptions.ProjectOptions.EXT_LD_FLAGS, k -> {
                boolean bl = this.getList((Enum<?>)k).add(outputValue);
            });
        }
    }

    @Override
    public void handleAddIncludePathSettingOperation(AddIncludePathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        String resolvedPath = this.resolveAndRelativizePath(operation.getUri());
        this.handleLanguageContent(operation, MakefileJinjaOptions.ProjectOptions.ASM_INCLUDES, MakefileJinjaOptions.ProjectOptions.C_CXX_INCLUDES, null, e -> {
            boolean bl = this.getList((Enum<?>)e).add("-I\"" + resolvedPath + "\"");
        });
    }

    @Override
    public void handleAddMacroDefinitionSettingOperation(AddMacroDefinitionSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        this.handleLanguageContent(operation, MakefileJinjaOptions.ProjectOptions.ASM_DEFINES, MakefileJinjaOptions.ProjectOptions.C_CXX_DEFINES, null, e -> {
            String string = this.getMap((Enum<?>)e).put(operation.getName(), TextUtils.isEmpty((String)operation.getValue()) ? "1" : operation.getValue());
        });
        String defStr = DefineUtils.formatDashDDefine(operation.getName(), TextUtils.isEmpty((String)operation.getValue()) ? "1" : operation.getValue());
        this.handleLanguageContent(operation, MakefileJinjaOptions.ProjectOptions.ASM_DEFINE_STR, MakefileJinjaOptions.ProjectOptions.C_CXX_DEFINE_STR, null, e -> {
            boolean bl = this.getList((Enum<?>)e).add(defStr);
        });
    }

    @Override
    public void handleAddLibraryFileSettingOperation(AddLibraryFileSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        String library;
        if (operation.getLibraryURI() == null) {
            library = "-l" + operation.getLibraryName().trim();
            this.getList(MakefileJinjaOptions.ProjectOptions.SYS_LIBS).add(library);
        } else {
            library = "\"" + this.resolveAndRelativizePath(operation.getLibraryURI()) + "\"";
            this.getList(MakefileJinjaOptions.ProjectOptions.USER_LIBS).add(library);
        }
        this.getList(MakefileJinjaOptions.ProjectOptions.ALL_LIBS).add(library);
    }

    @Override
    public void handleAddLibraryPathSettingOperation(AddLibraryPathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        String libraryPath = this.resolveAndRelativizePath(operation.getLibraryURI());
        this.getList(MakefileJinjaOptions.ProjectOptions.ALL_LIB_PATHS).add("-L\"" + libraryPath.trim() + "\"");
    }

    @Override
    public void handleAddModuleReferenceOperation(AddModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        this.metadata.modules().add(operation.getModuleReference());
    }

    @Override
    public void handleAddProjectDefinedModuleOperation(AddProjectDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        this.metadata.modules().add(operation.getModuleDefinition());
    }

    @Override
    public void handleResetModuleReferencesOperation(ResetModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
        this.metadata.modules().resetRefs();
    }

    @Override
    protected void registerProjectFile(IAddToProjectEngineOperation operation, IPath prjPath, File fileLoc) {
        if (!(operation instanceof IHandleFileProjectEngineOperation)) {
            return;
        }
        this.metadata.projectContent().registerFile(operation, prjPath, fileLoc);
        String relativeFile = this.getRelativePath(fileLoc);
        this.addedFiles.add(new AddFileOp(fileLoc, prjPath, relativeFile));
    }

    @Override
    public void handleExcludeResourceFromConfigurationOperation(ExcludeResourceFromConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
        this.excludedPaths.add(operation.getProjectPath());
        this.metadata.projectContent().registerExclusion(operation);
    }

    private void handleFileRegistration() {
        for (AddFileOp file : this.addedFiles) {
            if (!this.excludedPaths.contains(file.prjPath())) {
                this.getSortedList(MakefileJinjaOptions.ProjectOptions.ALL_SOURCES).add(file.relativeFile);
                if (ProjectFileUtils.isCFile(file.fileLoc)) {
                    this.getSortedList(MakefileJinjaOptions.ProjectOptions.C_SOURCES).add(file.relativeFile);
                    continue;
                }
                if (ProjectFileUtils.isCppFile(file.fileLoc)) {
                    this.getSortedList(MakefileJinjaOptions.ProjectOptions.CXX_SOURCES).add(file.relativeFile);
                    continue;
                }
                if (!ProjectFileUtils.isAsmFile(file.fileLoc)) continue;
                this.getSortedList(MakefileJinjaOptions.ProjectOptions.ASM_SOURCES).add(file.relativeFile);
                continue;
            }
            this.getSortedList(MakefileJinjaOptions.ProjectOptions.EXCLUDED_FILES).add(file.relativeFile);
        }
    }

    private void handleLanguageContent(IProjectLanguageSettingOperation op, Enum<?> asmOpt, Enum<?> cOpt, Enum<?> cppOpt, Consumer<Enum<?>> cons) {
        List<ELanguage> languages = ProjectModelUtils.getLanguagesFor(op);
        this.handleLanguageContent(languages, asmOpt, cOpt, cppOpt, null, cons);
    }

    private void handleLanguageContent(Collection<ELanguage> languages, Enum<?> asmOpt, Enum<?> cOpt, Enum<?> cppOpt, Enum<?> objOpt, Consumer<Enum<?>> cons) {
        if (languages.contains(ELanguage.ASM)) {
            cons.accept(asmOpt);
        }
        if (cppOpt == null || cppOpt == cOpt) {
            if (languages.contains(ELanguage.C) || languages.contains(ELanguage.CPP)) {
                cons.accept(cOpt);
            }
        } else {
            if (languages.contains(ELanguage.C)) {
                cons.accept(cOpt);
            }
            if (languages.contains(ELanguage.CPP)) {
                cons.accept(cppOpt);
            }
        }
        if (objOpt != null && languages.contains(ELanguage.OBJ)) {
            cons.accept(objOpt);
        }
    }

    private Map<String, String> getMap(Enum<?> key) {
        return (Map)MapUtils.findOrCreate(this.projectContentMap, (Object)key.name(), LinkedHashMap::new);
    }

    private List<String> getList(Enum<?> key) {
        return (List)MapUtils.findOrCreate(this.projectContentMap, (Object)key.name(), ArrayList::new);
    }

    protected Collection<String> getSortedList(Enum<?> key) {
        return (Collection)MapUtils.findOrCreate(this.projectContentMap, (Object)key.name(), MakefileJinjaOptions.SortedArrayList::new);
    }

    private String resolveAndRelativizePath(URI uri) {
        return this.formatPath(StudioExporterUtils.resolveAndRelativizePath(this.standardEngine, this.projectVariables, uri, true, this.relativePaths()));
    }

    private String getRelativePath(File fileLoc) {
        return this.formatPath(StudioExporterUtils.getRelativePath(fileLoc, true, this.relativePaths()));
    }

    private Path[] relativePaths() {
        return new Path[]{this.pkgPath, this.sdkDir, this.generationDir, this.copiedSdkDir};
    }

    private String formatPath(String path) {
        return path.replace(StudioExporterUtils.getVariableCounter(0), "$(PKG_PATH)/").replace(StudioExporterUtils.getVariableCounter(1), "$(SDK_PATH)/").replace(StudioExporterUtils.getVariableCounter(2), "").replace(StudioExporterUtils.getVariableCounter(3), "$(COPIED_SDK_PATH)/");
    }

    @Override
    public void handleAddProjectResourceFilterOperation(AddProjectResourceFilterOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleAddSourceFolderToConfigurationOperation(AddSourceFolderToConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleIncludeResourceIntoConfigurationOperation(IncludeResourceIntoConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleSetConfigurationOutputBaseNameOperation(SetConfigurationOutputBaseNameOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    private record AddFileOp(File fileLoc, IPath prjPath, String relativeFile) {
    }
}

