/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFileProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class GenericProjectContentMetadata
implements IExternalProjectMetadata<MProject> {
    private static final String KEY_PROJECT_SOURCES = "PROJECT_SOURCES";
    private MProject storageProject = ProjectModelFactory.eINSTANCE.createMProject();

    public void registerFile(IAddToProjectEngineOperation op, IPath prjPath, File fileLoc) {
        if (op instanceof IHandleFileProjectEngineOperation) {
            ProjectModelUtils.findOrCreateFileContent(null, this.storageProject, prjPath, fileLoc.toURI().toString());
        } else if (op instanceof CreateProjectFolderOperation) {
            ProjectModelUtils.findOrCreateFolder(null, (MFolderEntry)this.storageProject, prjPath);
        } else {
            ProjectModelUtils.findOrCreateFolderContent(null, this.storageProject, prjPath, fileLoc.getPath());
        }
    }

    public void registerExclusion(ExcludeResourceFromConfigurationOperation operation) {
        MConfiguration config = this.storageProject.findConfigurationByName(operation.getBuildConfiguration());
        if (config == null) {
            config = this.storageProject;
        }
        config.getExcludedPaths().add((Object)operation.getProjectPath().toString());
    }

    public void addConfiguration(IBuildConfiguration bconf) {
        if (bconf == null) {
            return;
        }
        ProjectModelUtils.findOrAddNewConfigurationFor(this.storageProject, (IBuildConfigurationDescriptor)bconf.getDescriptor());
    }

    public void clearContent() {
        this.storageProject = ProjectModelFactory.eINSTANCE.createMProject();
    }

    @Override
    public void apply(MProject project) {
        project.getFiles().addAll((Collection)this.storageProject.getFiles());
        project.getFolders().addAll((Collection)this.storageProject.getFolders());
        project.getConfigurations().addAll((Collection)this.storageProject.getConfigurations());
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MProject, ?> handler) {
        try {
            String mprojStr = ProjectModelLoading.storeMProjectModel((MProject)this.storageProject);
            handler.put(KEY_PROJECT_SOURCES, mprojStr);
        }
        catch (CoreException e) {
            Activator.reporter.logException((Throwable)e);
        }
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String mprojStr = handler.get(KEY_PROJECT_SOURCES);
        if (TextUtils.isEmpty((String)mprojStr)) {
            return;
        }
        try {
            this.storageProject = ProjectModelLoading.loadProjectModel((String)mprojStr);
        }
        catch (CoreException e) {
            Activator.reporter.logException((Throwable)e);
        }
    }
}

