/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.internal.api.core.external.impl.PropertyInfo;
import com.silabs.ss.framework.project.internal.core.type.ExternalOptionsUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IIarEwpCCAllowListOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IIARConfigurationInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class IarEwpExternalOptionUtils
extends ExternalOptionsUtils
implements IIARConfigurationInfo {
    public static final String IAR_EWP_ID = "iar.ewp";
    private static Map<ImporterTool, Map<String, PropertyInfo>> propertyInfoMapping = new HashMap<ImporterTool, Map<String, PropertyInfo>>();
    private static Map<ImporterTool.ToolType, ImporterTool> toolsARM = new HashMap<ImporterTool.ToolType, ImporterTool>();
    private static Map<ImporterTool.ToolType, ImporterTool> tools8051 = new HashMap<ImporterTool.ToolType, ImporterTool>();

    public ImporterTool getTool(ImporterTool.ToolchainID toolchain, ImporterTool.ToolType toolType) {
        switch (toolchain) {
            case ARM: {
                return toolsARM.get((Object)toolType);
            }
            case EIGHTYFIFTYONE: {
                return tools8051.get((Object)toolType);
            }
        }
        return null;
    }

    @Override
    public final PropertyInfo getPropertyInfo(String id, ImporterTool.ToolType type) {
        return this.getPropertyInfo(id, this.findTool(type));
    }

    public final PropertyInfo getPropertyInfo(String id, ImporterTool tool) {
        Map<String, PropertyInfo> registry = propertyInfoMapping.get(tool);
        if (registry == null) {
            return null;
        }
        return registry.get(id);
    }

    @Override
    public final PropertyInfo getPropertyInfo(String name, String version, ImporterTool.ToolType type) {
        return this.getPropertyInfo(PropertyInfo.generateId(name, version), type);
    }

    public final PropertyInfo getPropertyInfo(IIarEwpCCAllowListOptions option) {
        return this.getPropertyInfo(option.id(), option.tool());
    }

    protected abstract ImporterTool findTool(ImporterTool.ToolType var1);

    protected static void registerTool(ImporterTool.ToolchainID toolchain, ImporterTool.ToolType toolType, ImporterTool tool) {
        switch (toolchain) {
            case ARM: {
                toolsARM.put(toolType, tool);
                break;
            }
            case EIGHTYFIFTYONE: {
                tools8051.put(toolType, tool);
                break;
            }
            default: {
                throw new IllegalArgumentException("No toolchain for " + String.valueOf((Object)toolchain));
            }
        }
    }

    protected static final PropertyInfo registerPropertyInfo(PropertyInfo propertyInfo, ImporterTool tool) {
        propertyInfoMapping.computeIfAbsent(tool, t -> new HashMap()).put(propertyInfo.getId(), propertyInfo);
        return propertyInfo;
    }

    protected static void registerCCAllowList(IIarEwpCCAllowListOptions[] options) {
        Arrays.stream(options).forEach(o -> {
            PropertyInfo propertyInfo = IarEwpExternalOptionUtils.registerPropertyInfo(o.property(), o.tool());
        });
    }
}

