/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInHandler;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectImporter;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringListOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.URIListOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

public class IARIncludePaths {
    private static final String CXX_NODE_NAME = "CCIncludePath2";
    private final String ASM_NODE_NAME;
    private final StringListOption cxxOption;
    private final StringListOption asmOption;
    private IARConfiguration parent;

    public IARIncludePaths(IARConfiguration parent) {
        this.parent = parent;
        this.ASM_NODE_NAME = parent.configInfo.getAssemblerIncludesOptionName();
        this.cxxOption = (StringListOption)parent.getAndClear(CXX_NODE_NAME);
        this.asmOption = (StringListOption)parent.getAndClear(this.ASM_NODE_NAME);
    }

    public void addPath(String path, List<ELanguage> langs, boolean replace) {
        if (TextUtils.isEmpty((String)path)) {
            return;
        }
        if (langs.contains(ELanguage.C) || langs.contains(ELanguage.CPP)) {
            this.cxxOption.appendState(path, replace);
        }
        if (langs.contains(ELanguage.ASM)) {
            this.asmOption.appendState(path, replace);
        }
    }

    public void removeBuiltins(ProjectBuiltInHandler builtins) {
        this.cxxOption.removeNodes(s -> !"$FILE_DIR$".equals(s));
        this.asmOption.removeNodes(s -> !"$FILE_DIR$".equals(s));
    }

    public List<MBuildSetting> convert() {
        LinkedHashMap<String, MIncludePath> convertedContents = new LinkedHashMap<String, MIncludePath>();
        this.convertIncludes(convertedContents, this.cxxOption, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
        this.convertIncludes(convertedContents, this.asmOption, ProjectImportUtils.getELanguageString(ELanguage.ASM));
        return new ArrayList<MBuildSetting>(convertedContents.values());
    }

    private void convertIncludes(Map<String, MIncludePath> includes, BaseIAROption<?> includePathOption, String lang) {
        if (includePathOption == null) {
            return;
        }
        IPath projectFolder = this.parent.projectFolder();
        Set<String> unconvertedVariables = this.parent.getUnconvertedVariables();
        assert (includePathOption instanceof URIListOption || includePathOption instanceof StringListOption);
        for (String rawPath : includePathOption.getStateList()) {
            if (rawPath.contains("$TOOLKIT_DIR$")) {
                unconvertedVariables.add("$TOOLKIT_DIR$");
                continue;
            }
            if (rawPath.equals("$FILE_DIR$")) continue;
            MIncludePath mIncludePath = includes.get(rawPath);
            if (mIncludePath != null) {
                mIncludePath.setLanguageCompatibility(mIncludePath.getLanguageCompatibility() + " " + lang);
                continue;
            }
            mIncludePath = ProjectImportUtils.createMIncludePathFromString(rawPath, projectFolder.toFile().toURI(), lang, this.parent.variableReplacements, IARExternalProjectImporter.VARIABLE_PATTERN, unconvertedVariables);
            if (mIncludePath == null) continue;
            includes.put(rawPath, mIncludePath);
        }
    }
}

