/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile.options;

import com.google.common.collect.ImmutableMap;
import com.silabs.ss.framework.project.api.core.external.options.GenericAssemblerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCLinkerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericToolchainOptions;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingRegistryFactory;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileArmIarExternalOptions;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.Map;

public class MakefileArmIarGenericOptionMapper {
    private static final Map<String, String> replacementMap = ImmutableMap.of((Object)"", (Object)"$project/");

    public static IGenericOptionMappingRegistry iarRegistry() {
        IGenericOptionMappingRegistry registry = OptionMappingRegistryFactory.INSTANCE.createGenericOptionMappingRegistry();
        MakefileArmIarGenericOptionMapper.setupToolchainOptions(registry);
        MakefileArmIarGenericOptionMapper.setupCompilerOptions(registry);
        MakefileArmIarGenericOptionMapper.setupAssemblerOptions(registry);
        MakefileArmIarGenericOptionMapper.setupLinkerOptions(registry);
        return registry;
    }

    private static void setupToolchainOptions(IGenericOptionMappingRegistry registry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.IAR_CPU).mapFromTo(GenericToolchainOptions.Target.CPU, new Object[]{"--cpu=Cortex-M0+", "cortex-m0+", "--cpu=Cortex-M3", "cortex-m3", "--cpu=Cortex-M4.no_dsp", "cortex-m4", "--cpu=Cortex-M7.no_dsp", "cortex-m7", "--cpu=Cortex-M23.no_dsp", "cortex-m23", "--cpu=Cortex-M33.no_dsp", "cortex-m33", "--cpu=Cortex-M35P.no_dsp", "cortex-m35p", "--cpu=Cortex-M55.no_dsp", "cortex-m55"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.IAR_CPU_MODE).mapFromTo(GenericToolchainOptions.Target.THUMB_MODE, new Object[]{"--cpu_mode=thumb", true}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.IAR_FPU).mapFromTo(GenericToolchainOptions.Target.FPU, new Object[]{"--fpu=VFPv4_sp", "fpv4-sp", "--fpu=VFPv5_sp", "fpv5-sp"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.IAR_ENDIAN).mapFromTo(GenericToolchainOptions.Target.LITTLE_ENDIAN_MODE, new Object[]{"--endian=little", true}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
    }

    private static void setupCompilerOptions(IGenericOptionMappingRegistry registry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_MISC).mapTo(GenericCCompilerOptions.instance.MISC).mapToReplacing(GenericCCompilerOptions.instance.VARIABLE_MISC, replacementMap).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.GENERATE_SECURE_CODE).forSpecific((Object)"--cmse").mapTrue(new IProperty[]{GenericCCompilerOptions.Output.GENERATE_SECURE_CODE}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_STACK_PROTECTION).forSpecific((Object)"--stack_protection").mapTrue(new IProperty[]{GenericCCompilerOptions.Warnings.STACK_PROTECTION}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_PREINCLUDE).mapTo(GenericCCompilerOptions.Preprocessor.PREINCLUDE).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_DIALECT).mapFromTo(GenericCCompilerOptions.Language.C_STANDARD, new Object[]{"--c89", "c90", "", "c99", "", "c11", "", "c18"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_OPTIMIZATION).mapFromTo(GenericCCompilerOptions.Optimizer.OPTIMIZATION, new Object[]{"-On", "none", "-On", "debug", "-Ol", "low", "-Om", "medium", "-Ohs", "speed", "-Ohz", "size"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_CPP_INLINE).mapFromTo(GenericCCompilerOptions.Optimizer.INLINING, new Object[]{"--use_c++_inline", true, "", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_DEBUG_LEVEL).mapFromTo(GenericCCompilerOptions.Debug.DEBUG_LEVEL, new Object[]{"", "none", "--debug", "minimal", "--debug", "default", "--debug", "maximum"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_WARNINGS_AS_ERRORS).forSpecific((Object)"--warnings_are_errors").mapTrue(new IProperty[]{GenericCCompilerOptions.Warnings.WARNINGS_ARE_ERRORS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.COMPILER_LANGUAGE_CONFORMANCE).mapFromTo(GenericCCompilerOptions.Warnings.NON_STANDARD, new Object[]{"--strict", true, "-e", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
    }

    private static void setupAssemblerOptions(IGenericOptionMappingRegistry registry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.ASSEMBLER_MISC).mapTo(GenericAssemblerOptions.MISC).mapToReplacing(GenericAssemblerOptions.VARIABLE_MISC, replacementMap).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.ASSEMBLER_WARNINGS_AS_ERRORS).forSpecific((Object)"--warnings_are_errors").mapTrue(new IProperty[]{GenericAssemblerOptions.Warnings.WARNINGS_ARE_ERRORS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
    }

    private static void setupLinkerOptions(IGenericOptionMappingRegistry registry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.LINKER_MISC).mapTo(GenericCLinkerOptions.instance.MISC).mapToReplacing(GenericCLinkerOptions.instance.VARIABLE_MISC, replacementMap).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.LINKER_SCRIPT_PATH).mapToReplacing(GenericCLinkerOptions.Output.LINKER_SCRIPT, replacementMap).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.LINKER_MAP_FILE).forSpecific((Object)"--map=\"$(OUTPUT_DIR)/$(PROJECTNAME).map\"").mapTrue(new IProperty[]{GenericCLinkerOptions.Output.GENERATE_LINK_MAP}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmIarExternalOptions.TRUSTZONE_LIB_NAME).mapToReplacing(GenericCLinkerOptions.Output.TRUSTZONE_LIB_NAME, (Map)ImmutableMap.of((Object)"--import_cmse_lib_out=\"$(OUTPUT_DIR)/%1\"", (Object)"")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)registry);
    }
}

