/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.ses;

import com.google.common.collect.ImmutableSet;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.type.ExternalProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectToolOptionHandler;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeInfo;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.core.type.ses.SESExternalProjectType;
import com.silabs.ss.framework.project.internal.core.type.ses.SESGenericOptionsMapper;
import com.silabs.ss.framework.project.internal.core.type.ses.SESProjectOperationHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SESProjectType
extends ExternalProjectType {
    public static boolean SES_ENABLED = false;
    public static final String IDE_COMPATIBILITY = "segger-embedded-studio";
    private static final ImmutableSet<String> SES_EXTENSIONS = ImmutableSet.of((Object)"emProject");

    @Override
    public Collection<String> matchingKeywords() {
        if (!SES_ENABLED) {
            return List.of();
        }
        return Arrays.asList("ses", "SES", "emProject", "Segger Embedded Studio");
    }

    @Override
    public double getApplicability(IPath projectLocation) throws CoreException {
        if (!SES_ENABLED) {
            return -1.0;
        }
        String extension = projectLocation.getFileExtension();
        if (SES_EXTENSIONS.contains((Object)extension)) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public IProjectEngineOperationHandler createProjectEngineOperationHandler(IProjectEntity project) {
        if (!(project instanceof IExternalProjectEntity)) {
            throw new IllegalArgumentException("SES project generation requires an IExternalProjectEntity");
        }
        return new SESProjectOperationHandler((IExternalProjectEntity)project);
    }

    @Override
    public boolean toolchainSupportsProject(IToolchainDescriptor toolchain, IProjectDescriptor desc) {
        return false;
    }

    @Override
    public IExternalType getExternalType() {
        return new SESExternalProjectType();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (IProjectToolOptionHandler.class.equals(clazz)) {
            return clazz.cast(new SESToolOptionHandler());
        }
        if (IProjectTypeInfo.class.equals(clazz)) {
            return clazz.cast(new SESProjectTypeInfo());
        }
        return super.getAdapter(clazz);
    }

    @Override
    public Collection<File> getSupportedFiles(IProjectDescriptor desc, File directory, String baseName) {
        if (!SES_ENABLED) {
            return Collections.emptyList();
        }
        String toolchainCompatibility = desc.getPropertyAccess().getValueString(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
        if (TextUtils.hasContent((String)toolchainCompatibility) && !toolchainCompatibility.contains("gcc")) {
            return Collections.emptyList();
        }
        String core = (String)desc.getProperty(ProjectProperties.ALLOWED_CORE_ARCHITECTURE);
        if (!"ARM".equals(core)) {
            return Collections.emptyList();
        }
        if (SES_EXTENSIONS.stream().anyMatch(directory.getName()::endsWith)) {
            return Arrays.asList(directory);
        }
        List<File> supportedFiles = SES_EXTENSIONS.stream().map(e -> new File(directory, baseName + "." + e)).collect(Collectors.toList());
        return supportedFiles;
    }

    private class SESProjectTypeInfo
    implements IProjectTypeInfo {
        private SESProjectTypeInfo() {
        }

        @Override
        public String ideCompatibilityId() {
            return SESProjectType.IDE_COMPATIBILITY;
        }
    }

    private class SESToolOptionHandler
    implements IProjectToolOptionHandler {
        private SESToolOptionHandler() {
        }

        @Override
        public Collection<IGenericOptionMappingRegistry> getGenericOptionMappingRegistry(IProjectDescriptor proj, ISelectableDescriptor context) {
            return Arrays.asList(SESGenericOptionsMapper.sesOptionRegistry());
        }
    }
}

