/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.slsproj;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.BaseExternalSolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionBuildStep;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfig;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfigSettings;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.model.util.manual.SolutionModelLoading;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionConfigProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.BaseSolutionConfigEngineOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.CreateSolutionConfigOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.ResetSolutionModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetGeneralPropertyOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetNameOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPrebuildStepOperation;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.solution.SolutionModelUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SlsprojSolutionOperationHandler
extends BaseExternalSolutionEngineOperationHandler
implements ISolutionEngineOperationHandler {
    protected MSolution model;
    private Map<String, MSolutionConfig> configMap;

    public SlsprojSolutionOperationHandler(ISolutionEntity solution) {
        super(solution);
    }

    @Override
    public void load() throws CoreException {
        this.model = SolutionModelFactory.eINSTANCE.createMSolution();
        this.configMap = new HashMap<String, MSolutionConfig>();
    }

    @Override
    public void commit() throws CoreException {
        try {
            SolutionModelLoading.saveSolution((MSolution)this.model, (File)this.getSolutionEntity().getInstallationPath().toFile());
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to save solution", (Throwable)e);
        }
    }

    @Override
    public void handleResetSolutionModuleReferencesOperation(ResetSolutionModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleSetSolutionConfigPrebuildStepOperation(SetSolutionConfigPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionBuildStep buildStep = SolutionModelUtils.createBuildStep(operation.buildStep());
        buildStep.setBuiltin(operation.isBuiltIn());
        this.solutionConfig(operation).setPrebuildStep(buildStep);
    }

    @Override
    public void handleSetSolutionConfigPostbuildStepOperation(SetSolutionConfigPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionBuildStep buildStep = SolutionModelUtils.createBuildStep(operation.buildStep());
        buildStep.setBuiltin(operation.isBuiltIn());
        this.solutionConfig(operation).setPostbuildStep(buildStep);
    }

    @Override
    public void handleAddSolutionModuleReferenceOperation(AddSolutionModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionModuleReference ref = SolutionModelFactory.eINSTANCE.createMSolutionModuleReference();
        ref.setId(operation.moduleId());
        this.solutionConfig(operation).getSolutionModuleReferences().add((Object)ref);
    }

    @Override
    public void handleAddSolutionDefinedModuleOperation(AddSolutionDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        this.model.getSolutionDefinedModules().add((Object)operation.module());
    }

    @Override
    public void handleAddProjectOperation(AddSolutionProjectOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionProject project = SolutionModelFactory.eINSTANCE.createMSolutionProject();
        project.setName(operation.projectName());
        project.setLocation(operation.location());
        project.setBuiltin(operation.isBuiltin());
        this.model.getProjects().add((Object)project);
    }

    @Override
    public void handleAddSolutionConfigProjectOperation(AddSolutionConfigProjectOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionProject project = SolutionModelFactory.eINSTANCE.createMSolutionProject();
        project.setName(operation.projectName());
        project.setConfiguration(operation.projectConfig());
        project.setBinary(operation.binary());
        project.setBuiltin(operation.isBuiltin());
        this.solutionConfig(operation).getProjects().add((Object)project);
    }

    @Override
    public void handleCreateSolutionConfigOperation(CreateSolutionConfigOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionConfig config = (MSolutionConfig)this.solutionConfig(operation);
        config.setBuiltin(operation.isBuiltin());
        this.model.getConfigs().add((Object)config);
    }

    @Override
    public void handleSetNameOperation(SetNameOperation operation, IProgressMonitor monitor) throws CoreException {
        this.model.setName(operation.name());
        this.model.setLabel(operation.label());
    }

    @Override
    public void handleSetGeneralPropertyOperation(SetGeneralPropertyOperation operation, IProgressMonitor monitor) throws CoreException {
        this.solutionConfig(operation).putPropertyEntry(operation.key(), operation.value(), operation.isBuiltin());
    }

    private MSolutionConfigSettings solutionConfig(BaseSolutionConfigEngineOperation operation) {
        if (TextUtils.isEmpty((String)operation.solutionConfig())) {
            return this.model;
        }
        return (MSolutionConfigSettings)this.configMap.computeIfAbsent(operation.solutionConfig(), n -> {
            MSolutionConfig config = SolutionModelFactory.eINSTANCE.createMSolutionConfig();
            config.setName(n);
            return config;
        });
    }
}

