/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.util.function.Supplier;

public class ObjectCache<T>
implements Supplier<T> {
    private T data;
    private final Supplier<T> supplier;
    private long timestamp;
    private final long expiration;

    public ObjectCache(long expirationMillis, Supplier<T> supplier) {
        assert (supplier != null);
        this.data = null;
        this.timestamp = Long.MIN_VALUE;
        this.expiration = expirationMillis;
        this.supplier = supplier;
    }

    @Override
    public T get() {
        if (System.currentTimeMillis() > this.timestamp + this.expiration) {
            this.data = this.supplier.get();
            this.timestamp = System.currentTimeMillis();
        }
        return this.data;
    }

    public void set(T data) {
        this.data = data;
        this.timestamp = System.currentTimeMillis();
    }

    public void expire() {
        this.timestamp = Long.MIN_VALUE;
    }
}

