/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.enums;

public enum LineTerminator {
    NONE("", "None.", null),
    LF("\n", "LF", "Linux, Unix-like, Mac OS X"),
    CRLF("\r\n", "CR-LF", "DOS, OS/2, MS Windows"),
    CR("\r", "CR", "Mac OS up to 9, C64"),
    NEL("\u0085", "NEL", "Unicode: Next-Line"),
    FF("\f", "FF", "Unicode: Form-Feed"),
    LS("\u2028", "LS", "Unicode: Line-separator"),
    PS("\u2029", "PS", "Unicode: Paragraph-separator");

    private String terminator;
    private String shortDescription;
    private String platforms;
    private static String localTerminatorS;
    private static LineTerminator localTerminator;

    private LineTerminator(String terminator, String shortDescription, String platforms) {
        this.terminator = terminator;
        this.shortDescription = shortDescription;
        this.platforms = platforms;
    }

    public static String local() {
        return localTerminatorS;
    }

    public static LineTerminator localTerminator() {
        if (localTerminator == null) {
            for (LineTerminator lt : LineTerminator.values()) {
                if (!lt.terminator().equals(localTerminatorS)) continue;
                localTerminator = lt;
                break;
            }
        }
        return localTerminator;
    }

    public static LineTerminator forCodeGeneration() {
        return LF;
    }

    public static String local(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(localTerminatorS);
        }
        return sb.toString();
    }

    public String times(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(this.terminator);
        }
        return sb.toString();
    }

    public String terminator() {
        return this.terminator;
    }

    public String shortDescription() {
        return this.shortDescription;
    }

    public String longDescription() {
        if (this.platforms == null) {
            return this.shortDescription;
        }
        return this.shortDescription + "  (" + this.platforms + ")";
    }

    public String toString() {
        return this.terminator;
    }

    static {
        localTerminatorS = System.getProperty("line.separator");
        localTerminator = null;
    }
}

