/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.extension;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.extension.IExtensionElementHandler;
import com.silabs.java.utils.extension.IExtensionHandler;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.IExtensionMechanism;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.runtime.RuntimeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class Extension {
    private final Map<String, String[]> extensions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, IExtensionMechanism> mechanisms = new HashMap();

    public static Extension instance() {
        return LazyInstantiator.INSTANCE;
    }

    Extension() {
    }

    public void addMechanism(IExtensionMechanism mechanism) {
        this.mechanisms.put(mechanism.getClass(), mechanism);
    }

    public void removeMechanism(IExtensionMechanism mechanism) {
        this.mechanisms.remove(mechanism.getClass(), mechanism);
    }

    public Stream<IExtensionInformation> extensions(String extensionPointId) {
        return this.extensions(extensionPointId, e -> e);
    }

    public <T> Stream<T> extensions(String extensionPointId, IExtensionHandler<T> handler) {
        this.checkValid(extensionPointId);
        return this.mechanisms.values().stream().flatMap(mechanism -> mechanism.extensions(extensionPointId, handler));
    }

    public void registerExtensionListener(String extensionPointId, IExtensionElementHandler handler) {
        this.checkValid(extensionPointId);
        this.mechanisms.values().forEach(mechanism -> mechanism.registerExtensionListener(extensionPointId, handler));
    }

    public void removeExtensionListener(String extensionPointId, IExtensionElementHandler handler) {
        this.checkValid(extensionPointId);
        this.mechanisms.values().forEach(mechanism -> mechanism.removeExtensionListener(extensionPointId, handler));
    }

    private void checkValid(String extensionPointId) {
        if (!this.mechanisms.isEmpty()) {
            return;
        }
        Log.warning("No extension mechanisms loaded but accessing for " + extensionPointId, ExceptionUtils.newMinimalStackException());
        if (RuntimeUtils.isJUnitRunning()) {
            throw new IllegalStateException("No extension mechanisms loaded but accessing for " + extensionPointId, ExceptionUtils.newMinimalStackException());
        }
    }

    public void recordExtensionInfo(String extensionPointId, Object[] implementations) {
        String[] implementationDetails = new String[implementations.length];
        for (int i = 0; i < implementationDetails.length; ++i) {
            implementationDetails[i] = TextUtils.print(implementations[i]);
        }
        this.extensions.put(extensionPointId, implementationDetails);
    }

    public String[] extensionInfo(String extensionPointId) {
        return this.extensions.get(extensionPointId);
    }

    public String[] extensionPointIds() {
        return this.extensions.keySet().toArray(new String[0]);
    }

    private static class LazyInstantiator {
        private static final Extension INSTANCE = new Extension();

        private LazyInstantiator() {
        }
    }
}

