/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class SilabsThreadFactory {
    private String namePattern;
    private boolean isDaemon = false;

    public static SilabsThreadFactory withName(String baseThreadName) {
        SilabsThreadFactory factory2 = new SilabsThreadFactory();
        factory2.namePattern = baseThreadName;
        return factory2;
    }

    public SilabsThreadFactory setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public ThreadFactory create() {
        return new ThreadFactory(){
            private final AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread2 = new Thread(r, SilabsThreadFactory.this.namePattern + "-" + this.count.getAndIncrement());
                thread2.setDaemon(SilabsThreadFactory.this.isDaemon);
                return thread2;
            }
        };
    }

    private SilabsThreadFactory() {
    }
}

