/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables.engine;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.java.utils.variables.engine.IOperation;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.IVariableSubstitutionEngine;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;

public class VariableSubstitutionEngine
implements IVariableSubstitutionEngine {
    public static int CODE_INTERNAL_ERROR = 0;
    public static int CODE_UNDEFINED_VARIABLE = 1;
    public static int CODE_NULL_VARIABLE = 2;
    public static int CODE_CIRCULAR_EXPANSION = 3;
    public static int CODE_OPERATION_ERROR = 4;
    private boolean recursive;
    private char openToken;
    private char closeToken;
    private boolean reportErrorIfUnknownVariableIsEncountered = true;
    private IVariableSubstutionListener listener;
    private IOperatorHandler operatorHandler;

    public static IVariableSubstitutionEngine create(char token) {
        return new VariableSubstitutionEngine(token, null);
    }

    public static IVariableSubstitutionEngine create(char token, IOperatorHandler handler, boolean reportErrorsOnUnknownVariable) {
        VariableSubstitutionEngine vse = new VariableSubstitutionEngine(token, handler);
        vse.reportErrorIfUnknownVariableIsEncountered = reportErrorsOnUnknownVariable;
        return vse;
    }

    public VariableSubstitutionEngine() {
        this('{', null);
    }

    public VariableSubstitutionEngine(char token) {
        this(token, null);
    }

    private VariableSubstitutionEngine(char token, IOperatorHandler operatorHandler) {
        this.setVariableToken(token);
        if (operatorHandler != null) {
            this.setOperatorHandler(operatorHandler);
        }
    }

    public void setVariableToken(char token) {
        if (token == '{') {
            this.openToken = (char)123;
            this.closeToken = (char)125;
        } else if (token == '(') {
            this.openToken = (char)40;
            this.closeToken = (char)41;
        } else if (token == '[') {
            this.openToken = (char)91;
            this.closeToken = (char)93;
        } else if (token == '$') {
            this.closeToken = (char)36;
            this.openToken = (char)36;
        } else {
            throw new IllegalArgumentException("only supports '(', '{', '$', and '['");
        }
    }

    public void setListener(IVariableSubstutionListener listener) {
        this.listener = listener;
    }

    public IVariableSubstutionListener getListener() {
        return this.listener;
    }

    @Override
    public String substitute(String string, IVariableLookup variableLookupCallback) {
        boolean replaced;
        if (string == null) {
            return null;
        }
        HashSet<String> replaces = new HashSet<String>();
        do {
            Pair<Pair<Integer, Integer>, String> match;
            HashSet<String> lineReplaces = new HashSet<String>();
            StringBuilder buffer = new StringBuilder();
            replaced = false;
            int startPosition = 0;
            int prevPosition = 0;
            while (startPosition < string.length() && (match = this.findNextReference(string, startPosition)) != null) {
                int lastCharacterMatched;
                Object value;
                String key = (String)match.second;
                int start = (Integer)((Pair)match.first).first;
                int end = (Integer)((Pair)match.first).second;
                String origKey = key;
                if (this.operatorHandler == null) {
                    value = variableLookupCallback.getValue(key);
                    if (value == null && key.equals("isPdeLaunch")) {
                        value = RuntimeUtils.isPlatformPDELaunch();
                    }
                    this.reportIfNull(variableLookupCallback, key, value);
                } else {
                    String[] varWithOperations = this.operatorHandler.splitVariableAndOperations(key);
                    if (varWithOperations == null || varWithOperations.length == 0) {
                        throw new IllegalStateException();
                    }
                    key = varWithOperations[0];
                    value = variableLookupCallback.getValue(key);
                    if (value == null && key.equals("isPdeLaunch")) {
                        value = RuntimeUtils.isPlatformPDELaunch();
                    }
                    boolean gotError = false;
                    for (int i = 1; i < varWithOperations.length; ++i) {
                        String operation = varWithOperations[i];
                        try {
                            value = this.operatorHandler.operate(operation, value);
                            continue;
                        }
                        catch (IOperation.OperationException e) {
                            gotError = true;
                            this.error(e.code(), MessageFormat.format("for variable ''{0}'', operation ''{1}'': {2}", key, operation, e.getMessage()), e);
                            continue;
                        }
                        catch (Throwable t) {
                            gotError = true;
                            this.error(CODE_INTERNAL_ERROR, "unexpected error during string substition", t);
                        }
                    }
                    if (!gotError) {
                        this.reportIfNull(variableLookupCallback, key, value);
                    }
                }
                if (this.recursive && replaces.contains(key) && !lineReplaces.contains(key)) {
                    this.error(CODE_CIRCULAR_EXPANSION, "Infinite recursion for variable '" + origKey + "' with value " + value, null);
                    startPosition = end;
                    continue;
                }
                replaces.add(key);
                lineReplaces.add(key);
                if (value == null) {
                    startPosition = end;
                    buffer.append(string.substring(prevPosition, end));
                    prevPosition = end;
                    continue;
                }
                String valueString = value.toString();
                buffer.append(string.substring(prevPosition, start));
                buffer.append(valueString);
                prevPosition = end;
                replaced = true;
                startPosition = lastCharacterMatched = end;
            }
            buffer.append(string.substring(prevPosition));
            string = buffer.toString();
        } while (this.recursive && replaced);
        return string;
    }

    private Pair<Pair<Integer, Integer>, String> findNextReference(String string, int startPosition) {
        StringBuilder sb = null;
        int pos = startPosition;
        int hardEnd = string.length();
        while (pos + 2 < hardEnd) {
            char ch;
            if ((ch = string.charAt(pos++)) != '$') continue;
            int start = pos - 1;
            if (this.openToken == '$') {
                // empty if block
            }
            int n = --pos;
            ++pos;
            ch = string.charAt(n);
            if (ch != this.openToken) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.setLength(0);
            }
            int nestCount = 1;
            while (pos < hardEnd) {
                if ((ch = string.charAt(pos++)) == this.closeToken) {
                    if (--nestCount == 0) {
                        break;
                    }
                } else if (ch == this.openToken) {
                    ++nestCount;
                }
                sb.append(ch);
            }
            return new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(start, pos), sb.toString());
        }
        return null;
    }

    private void reportIfNull(IVariableLookup variableLookupCallback, String key, Object value) {
        if (value == null) {
            if (variableLookupCallback.getVariableNames().contains(key)) {
                this.error(CODE_NULL_VARIABLE, "Null variable '" + key + "'", null);
            } else if (this.reportErrorIfUnknownVariableIsEncountered) {
                this.error(CODE_UNDEFINED_VARIABLE, "Undefined variable '" + key + "'", null);
            }
        }
    }

    private void error(int code, String msg, Throwable e) {
        if (e == null) {
            e = ExceptionUtils.newMinimalStackException();
        }
        if (this.listener != null) {
            this.listener.error(code, msg, e);
        } else {
            Log.error(msg, e);
        }
    }

    public String substitute(String string, Map<String, Object> variables) {
        return this.substitute(string, new MapVariableLookup(variables));
    }

    public void allowRecursion(boolean enable) {
        this.recursive = enable;
    }

    public String wrapVariable(String var) {
        return "$" + this.openToken + var + this.closeToken;
    }

    public char getVariableToken() {
        return this.openToken;
    }

    public void setOperatorHandler(IOperatorHandler handler) {
        this.operatorHandler = handler;
    }

    public IOperatorHandler getOperatorHandler() {
        return this.operatorHandler;
    }

    public static interface IVariableSubstutionListener {
        public static final IVariableSubstutionListener SILENT = (code, message, cause) -> {};

        public void error(int var1, String var2, Throwable var3);
    }
}

