/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.zip;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.api.ICanceler;
import com.silabs.java.utils.function.ThrowableConsumer;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.zip.ICompressionAlgorithm;
import com.silabs.java.utils.zip.ICompressionEntry;
import com.silabs.java.utils.zip.ICompressionInputStream;
import com.silabs.java.utils.zip.ZipFileGroup;
import com.silabs.java.utils.zip.impl.CompressionUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 1024;
    private static final long MAX_CONTENT_SIZE = 0x130000000L;
    private static final int MAX_FILE_COUNT = 8192;

    public static File zipFiles(String zippath, List<? extends FileGroup> groups2) throws IOException {
        ZipUtils.zipFiles(new File(zippath), groups2, ICanceler.NEVER_CANCEL);
        return null;
    }

    public static File zipArchiveFiles(String zippath, List<? extends FileGroup> groups2) throws IOException {
        return ZipUtils.zipFiles(zippath, groups2);
    }

    public static void unzip(URL zip2, File outputDirectory) throws IOException {
        ZipUtils.unzip(zip2, outputDirectory, false);
    }

    public static void unzip(URL zip2, File outputDirectory, boolean setPerms) throws IOException {
        ZipUtils.unzip(zip2, outputDirectory, null, setPerms, s -> {});
    }

    public static void unzip(URL zip2, File outputDirectory, String[] dirNames, boolean setPerms, Consumer<String> operationCallback) throws IOException {
        ZipUtils.unzip(CompressionUtils.create(zip2), zip2, outputDirectory, dirNames, setPerms, operationCallback);
    }

    public static void unzip(ICompressionAlgorithm algorithm, URL zip2, File outputDirectory, String[] dirNames, boolean setPerms, Consumer<String> operationCallback) throws IOException {
        ZipUtils.unzip(algorithm, zip2, outputDirectory, dirNames, setPerms, 8192, 0x130000000L, operationCallback);
    }

    public static void unzip(ICompressionAlgorithm algorithm, URL zip2, File outputDirectory, String[] dirNames, boolean setPerms, int maxFiles, long maxSize, Consumer<String> operationCallback) throws IOException {
        Path outPath = outputDirectory.toPath().normalize().toAbsolutePath();
        HashSet<String> dirNameSet = dirNames == null ? null : new HashSet<String>(Arrays.asList(dirNames));
        int numFiles = 0;
        long totalSize = 0L;
        try (ICompressionInputStream cis = algorithm.open(zip2);){
            ICompressionEntry nextEntry;
            byte[] buff = new byte[1024];
            while ((nextEntry = cis.getNextEntry()) != null) {
                int mode;
                Path entryPath;
                block22: {
                    String firstSegment;
                    if (dirNameSet != null && !dirNameSet.contains(firstSegment = Path.of(nextEntry.getName(), new String[0]).getName(0).toString())) continue;
                    operationCallback.accept(nextEntry.getName());
                    if (nextEntry.isDirectory()) {
                        Path dir = ZipUtils.getUnzippedFile(outPath, nextEntry.getName());
                        Files.createDirectories(dir, new FileAttribute[0]);
                        continue;
                    }
                    entryPath = ZipUtils.getUnzippedFile(outPath, nextEntry.getName());
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    if (nextEntry.isLink()) {
                        if (Files.isRegularFile(entryPath, new LinkOption[0]) || Files.isSymbolicLink(entryPath)) {
                            Files.deleteIfExists(entryPath);
                        }
                        Files.createSymbolicLink(entryPath, Path.of(nextEntry.getLinkName(), new String[0]), new FileAttribute[0]);
                    } else {
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(entryPath.toFile()));){
                            int cnt;
                            do {
                                if ((cnt = cis.read(buff)) == -1) {
                                    cis.closeEntry();
                                    break block22;
                                }
                                ((OutputStream)fos).write(buff, 0, cnt);
                            } while ((totalSize += (long)cnt) <= maxSize);
                            throw new IOException("Zip file is too large to unzip!");
                        }
                    }
                }
                if (++numFiles > maxFiles) {
                    throw new IOException("Zip file has too many files to unzip!");
                }
                if (!setPerms || (mode = nextEntry.getMode()) == 0) continue;
                boolean success = true;
                if ((mode & 4) != 0) {
                    success &= entryPath.toFile().setReadable(true, false);
                }
                if ((mode & 2) != 0) {
                    success &= entryPath.toFile().setWritable(true, false);
                }
                if ((mode & 1) != 0) {
                    success &= entryPath.toFile().setExecutable(true, false);
                }
                if (success) continue;
                ZipUtils.logWarning("Failed to update permissions for " + entryPath, null);
            }
        }
    }

    private static Path getUnzippedFile(Path outDir, String entryName) throws IOException {
        Path entryPath = outDir.resolve(entryName).normalize().toAbsolutePath();
        if (entryPath.startsWith(outDir)) {
            return entryPath;
        }
        throw new IOException("Attempting to expand outside of expansion directory! " + "Expanded path '" + entryPath + "' is outside of expansion root '" + outDir + "'");
    }

    public static void zipDirectory(File zipFile, File directory, ICanceler monitor) throws IOException {
        ZipUtils.doRunZip(zipFile, zipStream -> ZipUtils.addZipDirectory(zipStream, directory, directory.toPath(), monitor));
    }

    private static void addZipDirectory(ZipOutputStream zipStream, File directory, Path root, ICanceler monitor) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        byte[] buff = new byte[1000];
        for (File file : files) {
            if (monitor.isCanceled()) {
                throw new CancellationException();
            }
            if (file.isDirectory()) {
                ZipUtils.addZipDirectory(zipStream, file, root, monitor);
                continue;
            }
            ZipUtils.zipFile(zipStream, buff, file, root.relativize(file.toPath()).toString(), monitor);
        }
    }

    public static void zipFiles(File zippath, List<? extends ZipFileGroup> groups2, ICanceler monitor) throws IOException {
        ZipUtils.doRunZip(zippath, out -> ZipUtils.doZipFileGroups(zippath, groups2, monitor, out));
    }

    public static void zipArchiveFiles(File zippath, List<? extends ZipFileGroup> groups2, ICanceler monitor) throws IOException {
        ZipUtils.zipFiles(zippath, groups2, monitor);
    }

    private static void doZipFileGroups(File zippath, List<? extends ZipFileGroup> groups2, ICanceler monitor, ZipOutputStream out) {
        byte[] buff = new byte[1024];
        for (ZipFileGroup zipFileGroup : groups2) {
            if (zipFileGroup == null) continue;
            Object groupZipPath = "";
            if (TextUtils.hasContent(zipFileGroup.getZipPath())) {
                groupZipPath = zipFileGroup.getZipPath() + "/";
            }
            for (Map.Entry<File, String> entry : zipFileGroup.getEntries().entrySet()) {
                File file = entry.getKey();
                try {
                    ZipUtils.zipFile(out, buff, file, (String)groupZipPath + entry.getValue(), monitor);
                }
                catch (FileNotFoundException e) {
                }
                catch (CancellationException e) {
                    return;
                }
                catch (Throwable t) {
                    ZipUtils.logError("Error adding file " + file + " to " + zippath, t);
                }
            }
        }
    }

    private static void logError(String errorStr, Throwable t) {
        Log.error(errorStr, t);
    }

    private static void logWarning(String warnStr, Throwable t) {
        Log.warning(warnStr, t);
    }

    private static void doRunZip(File zipFile, ThrowableConsumer<ZipOutputStream, IOException> consumer) throws IOException {
        if (zipFile == null) {
            return;
        }
        try (ZipOutputStream zipStream2 = new ZipOutputStream(new FileOutputStream(zipFile));){
            consumer.accept(zipStream2);
        }
        catch (CancellationException zipStream2) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    private static void zipFile(ZipOutputStream zipStream, byte[] buff, File file, String path, ICanceler monitor) throws IOException, FileNotFoundException {
        ZipEntry zipEnt = new ZipEntry(path);
        ZipUtils.setMinimalPermission(file, zipEnt);
        zipStream.putNextEntry(zipEnt);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            while (true) {
                if (monitor.isCanceled()) {
                    throw new CancellationException();
                }
                int cnt = ((InputStream)is).read(buff);
                if (cnt == -1) {
                    break;
                }
                zipStream.write(buff, 0, cnt);
            }
        }
        zipStream.closeEntry();
    }

    private static void setMinimalPermission(File file, ZipEntry zipEnt) {
        byte[] extra = new byte[]{4};
        if (file.canWrite()) {
            extra[0] = (byte)(extra[0] | 2);
        }
        if (file.canExecute()) {
            extra[0] = (byte)(extra[0] | 1);
        }
        zipEnt.setExtra(extra);
    }

    public static class FileGroup
    extends ZipFileGroup {
        public FileGroup(File baseDir, String zipPath) {
            super(baseDir, zipPath);
        }
    }
}

