/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.shared;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.log.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class DaemonVersionInfo {
    private final Map<String, String> versionInfo;

    public static DaemonVersionInfo create(Path versionFile) {
        Map<String, String> versionData = DaemonVersionInfo.loadFromFile(versionFile);
        if (versionData == null || versionData.isEmpty()) {
            return null;
        }
        return new DaemonVersionInfo(versionData);
    }

    protected DaemonVersionInfo(Map<String, String> versionInfo) {
        this.versionInfo = versionInfo;
    }

    private static Map<String, String> loadFromFile(Path versionFile) {
        Properties versionPlugins;
        if (!Files.exists(versionFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Version file: " + versionFile + " does not exist -- cannot compare.");
        }
        try {
            versionPlugins = FileUtils.readProperties(versionFile.toFile());
        }
        catch (IOException e) {
            Log.warning("Issue comparing a version file: " + versionFile);
            return null;
        }
        return DaemonVersionInfo.convertMap(versionPlugins);
    }

    protected static Map<String, String> convertMap(Map<?, ?> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
    }

    public String versionContent() {
        return this.versionInfo.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }

    public VersionComparison strictVersionCompare(Path versionFile) {
        DaemonVersionInfo theirInfo = DaemonVersionInfo.create(versionFile);
        if (theirInfo == null) {
            return VersionComparison.BROKEN;
        }
        return this.versionInfo.equals(theirInfo.versionInfo) ? VersionComparison.SAME : VersionComparison.DIFFERENT;
    }

    public static enum VersionComparison {
        SAME,
        DIFFERENT,
        BROKEN;

    }
}

