/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.shared;

import com.silabs.java.utils.HostUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public interface ISlcDaemon {
    public String daemonName();

    default public Path location() {
        return this.location(HostUtils.userHomeFile().toPath());
    }

    default public Path location(Path rootDir) {
        return rootDir.resolve(".uc/cli");
    }

    default public Path newFolder() throws IOException {
        return this.newFolder(this.location());
    }

    default public Path newFolder(Path destination) throws IOException {
        String fileName = this.newFolderName(destination);
        return destination.resolve(fileName);
    }

    default public String newFolderName(Path destination) throws IOException {
        Path originalDest;
        if (Files.isRegularFile(destination, new LinkOption[0])) {
            throw new IllegalArgumentException("Expecting a directory path but got a file: " + destination);
        }
        String rawFoldername = this.folderName();
        Object calculatedFoldername = rawFoldername;
        Path expectedDest = originalDest = destination.resolve(rawFoldername);
        int counter = 0;
        boolean foundPlace = false;
        do {
            if (!Files.exists(expectedDest, new LinkOption[0])) {
                foundPlace = true;
                continue;
            }
            calculatedFoldername = rawFoldername + "_" + counter;
            expectedDest = destination.resolve((String)calculatedFoldername);
            ++counter;
        } while (!foundPlace);
        return calculatedFoldername;
    }

    default public String folderName() {
        return this.daemonName() + "_pdata";
    }
}

