/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.instrumented;

import com.silabs.uc.cli.instrumented.configuration.internal.api.instrument.shared.JavaVMArgumentSetter;
import com.silabs.uc.cli.instrumented.configuration.internal.api.instrument.shared.JsonPayloadArgumentSetter;
import com.silabs.uc.cli.instrumented.configuration.internal.api.instrument.shared.SlcCliTelemetryConfigure;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.List;
import org.json.JSONObject;
import slc.launcher.utils.SlcDefaultLogger;

public final class JavaLauncherTelemetryUtils {
    public static String OT_ENABLED = "slc.launcher.ot.enabled";
    private static final String PRIMARY_NAME = "launcher-core";
    private static OpenTelemetry launcherTelemetry = OpenTelemetry.noop();

    private JavaLauncherTelemetryUtils() {
    }

    public static boolean isOtEnabled() {
        return Boolean.parseBoolean(System.getProperty(OT_ENABLED));
    }

    public static void enableOtIfRequested() {
        if (JavaLauncherTelemetryUtils.isOtEnabled()) {
            SlcDefaultLogger logger = SlcDefaultLogger.instance();
            OpenTelemetry ot = SlcCliTelemetryConfigure.initialiseForSlcCliCore(logger.toLogger());
            JavaLauncherTelemetryUtils.injectOpenTelemetryInstance(ot);
        }
    }

    private static void injectOpenTelemetryInstance(OpenTelemetry telemetry) {
        launcherTelemetry = telemetry;
    }

    public static Tracer launcherCoreTracer() {
        return launcherTelemetry.getTracerProvider().tracerBuilder(PRIMARY_NAME).build();
    }

    public static OpenTelemetry openTelemetry() {
        return launcherTelemetry;
    }

    public static void shutdown() {
        SlcCliTelemetryConfigure.shutdown(launcherTelemetry);
    }

    public static void injectContextInArgs(List<String> args2) {
        if (JavaLauncherTelemetryUtils.isOtEnabled()) {
            OpenTelemetry ot = launcherTelemetry;
            ot.getPropagators().getTextMapPropagator().inject(Context.current(), args2, JavaVMArgumentSetter.instance());
        }
    }

    public static void injectContextInJson(JSONObject payload) {
        if (JavaLauncherTelemetryUtils.isOtEnabled()) {
            OpenTelemetry ot = launcherTelemetry;
            ot.getPropagators().getTextMapPropagator().inject(Context.current(), payload, JsonPayloadArgumentSetter.instance());
        }
    }
}

