/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.templates;

import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateContext;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.ITemplateExecuteProcessesExtension;
import com.silabs.ss.framework.project.api.templates.Template;
import com.silabs.ss.framework.project.api.templates.TemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.internal.templates.Activator;
import com.silabs.ss.framework.project.internal.templates.manager.TemplateManager;
import com.silabs.ss.platform.api.content.core.asset.AssetUtilities;
import com.silabs.ss.platform.api.content.core.asset.IAssetService;
import com.silabs.ss.platform.api.descriptor.core.BaseDescriptorEntity;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.ServiceReference;

public class BaseTemplate
extends BaseDescriptorEntity<ITemplateDescriptor>
implements ITemplate {
    private static IAssetService assetService;

    static {
        ServiceReference serviceReference = Activator.getContext().getServiceReference(IAssetService.class.getName());
        assetService = (IAssetService)Activator.getContext().getService(serviceReference);
    }

    public BaseTemplate(ITemplateDescriptor desc, String providingBundleId) throws CoreException {
        super((IDescriptor)desc, providingBundleId);
        URI uri = (URI)this.getProperty(CoreProperties.INSTALLATION_PATH);
        this.updateInstallPath(uri);
    }

    private URI updateInstallPath(URI uri) throws CoreException {
        if (AssetUtilities.isAssetURI((URI)uri)) {
            try {
                File f = assetService.resolveAsset(uri, false, null);
                this.installPath = new Path(f.getPath());
                this.setProperty(CoreProperties.INSTALLATION_PATH, f.toURI());
                return f.toURI();
            }
            catch (Exception e) {
                throw Activator.reporter.newCoreException("Fail to create template due to failure in resolving template installation path: " + String.valueOf(uri), (Throwable)e);
            }
        }
        return uri;
    }

    public String getId() {
        return ((ITemplateDescriptor)this.getDescriptor()).getId();
    }

    protected String getDefaultPropertyScope() {
        return "template";
    }

    @Override
    public String getDefaultName() {
        return this.getProperty(TemplateProperties.DEFAULT_NAME);
    }

    @Override
    public void executeTemplateProcesses(ITemplateContext context, IProgressMonitor monitor) throws CoreException {
        Collection<ITemplateExecuteProcessesExtension> exts = this.getProcessExtensions();
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)exts.size());
        exts.forEach(e -> e.executeTemplateProcesses(this, context, (IProgressMonitor)submon.split(1)));
    }

    private Collection<ITemplateExecuteProcessesExtension> getProcessExtensions() {
        if (this.getManager() instanceof TemplateManager) {
            return ((TemplateManager)this.getManager()).getTemplateExtensions();
        }
        if (Template.manager() instanceof TemplateManager) {
            return ((TemplateManager)Template.manager()).getTemplateExtensions();
        }
        return Collections.emptyList();
    }

    public IPath getInstallationPath() throws IOException {
        URI uri = (URI)this.getProperty(CoreProperties.INSTALLATION_PATH);
        try {
            uri = this.updateInstallPath(uri);
        }
        catch (CoreException e) {
            Activator.reporter.logException((Throwable)e);
        }
        return uri == null ? Path.EMPTY : URIUtils.resolveURIToPath((URI)uri);
    }

    public Object getProperty(String key) {
        URI installPath = TemplateDescriptor.checkInstallPath(key, (IDescriptor)this);
        if (installPath != null) {
            return installPath;
        }
        return super.getProperty(key);
    }

    public <T> T getProperty(PropertyReference<T> property) throws IllegalArgumentException {
        URI installPath = TemplateDescriptor.checkInstallPath(property.id(), (IDescriptor)this);
        if (installPath != null) {
            return (T)property.type().castToType((Object)installPath);
        }
        return (T)super.getProperty(property);
    }

    protected URI getTemplateInstallPath() {
        return TemplateDescriptor.getTemplateInstallPath((IDescriptor)this);
    }
}

