/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.templates;

import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.core.model.ProjectModelPackage;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelResourceFactoryImpl;
import com.silabs.ss.framework.project.api.templates.IWriteableTemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.Template;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.platform.api.descriptor.core.BaseDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.StudioModelFactory;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import java.net.URI;
import java.util.Collection;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class TemplateDescriptor
extends BaseDescriptor
implements IWriteableTemplateDescriptor {
    private ResourceSet resourceSet;

    public TemplateDescriptor() {
        this(StudioModelFactory.eINSTANCE.createMDescriptor());
    }

    public TemplateDescriptor(MDescriptor desc) {
        super(desc);
        this.createResourceSet();
    }

    private void createResourceSet() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getPackageRegistry().put(null, (Object)ProjectModelPackage.eINSTANCE);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ProjectModelResourceFactoryImpl());
    }

    public void setRegistry(IRegistry<? extends IDescriptor> registry) {
        if (Template.manager().getRegistry() == registry) {
            registry = Template.manager();
        }
        super.setRegistry(registry);
    }

    public String getId() {
        return this.getNamespace() + "." + super.getId();
    }

    protected String getDefaultPropertyScope() {
        return "template";
    }

    @Override
    public String getCategory() {
        return (String)this.getProperty(CoreProperties.CATEGORY);
    }

    @Override
    public String getNamespace() {
        if (!this.getPropertyAccess().isValueNonDefault(TemplateProperties.NAMESPACE)) {
            return "template";
        }
        return this.getProperty(TemplateProperties.NAMESPACE);
    }

    @Override
    @Deprecated
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Object getProperty(String key) {
        URI installPath = TemplateDescriptor.checkInstallPath(key, this);
        if (installPath != null) {
            return installPath;
        }
        return super.getProperty(key);
    }

    public <T> T getProperty(PropertyReference<T> property) throws IllegalArgumentException {
        URI installPath = TemplateDescriptor.checkInstallPath(property.id(), this);
        if (installPath != null) {
            return (T)property.type().castToType((Object)installPath);
        }
        return (T)super.getProperty(property);
    }

    static URI checkInstallPath(String key, IDescriptor desc) {
        URI installPath;
        if ("installationPath".equals(key) && (installPath = TemplateDescriptor.getTemplateInstallPath(desc)) != null) {
            return installPath;
        }
        return null;
    }

    static URI getTemplateInstallPath(IDescriptor desc) {
        if (!desc.getPropertyAccess().isValueNonDefault(TemplateProperties.PROJECT_URIS)) {
            return null;
        }
        Collection projectURIs = (Collection)desc.getProperty(TemplateProperties.PROJECT_URIS);
        String[] stringArray = IDEPreferenceManager.getPreferredIDE().getProjectFileExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectExt = stringArray[n2];
            for (URI uri : projectURIs) {
                if (!uri.toString().endsWith(projectExt)) continue;
                return uri;
            }
            ++n2;
        }
        return null;
    }
}

